

//==============================================================================
//TAG_PlayerPawn
//
// Instead of just representing the player, should be able to handle all the 
// collisions as well - namely, laser weapons only do damage to socket hitboxes
// for the:
//	 l/r shoulders = 100 + stun period
//	 f/b chest = 50 + stun period
//	 l/r gun barrel = 60 + Longer stun period
//	 u/d gun barrel = 70 + Longer stun period
//	 inside gun barrel = 80 + Even Longer stun period

//class TAG_PlayerPawn extends MSPawn;
class TAG_PlayerPawn extends UTPawn;

//Variables for loading custom assets

var ParticleSystem particleSystemComponent;
var SkeletalMesh defaultMesh;
var MaterialInterface defaultMaterial0;
var AnimTree defaultAnimTree;
var array<AnimSet> defaultAnimSet;
var AnimNodeSequence defaultAnimSeq;
var PhysicsAsset defaultPhysicsAsset;

var ParticleSystemComponent psg;

var ParticleSystemComponent playerParticleEmitterBack;
var ParticleSystemComponent playerParticleEmitterTop;


var SkelControlBase ASkelControl;


var BOOL logging;

exec function startLogging(){
	logging = !logging;
}


simulated function SetCharacterClassFromInfo(class<UTFamilyInfo> Info)
{

`log("[TAG.TAG_Player_Pawn] SetCharacterClassFromInfo called");
Mesh.SetSkeletalMesh(defaultMesh);
//Mesh.SetMaterial(0,defaultMaterial0);
//Mesh.SetPhysicsAsset(defaultPhysicsAsset);
//Mesh.AnimSets=defaultAnimSet;
//Mesh.SetAnimTreeTemplate(defaultAnimTree);
} 


//Technically may not be called except here



//Does nothing new at the moment...
//Need to figure out how to attach to player Pawn
/*
simulated function PostBeginPlay(){
	super.PostBeginPlay();
	SetCharacterClassFromInfo();
	Mesh.AttachComponentToSocket(psg, 'StupidSocket');
}
*/

/*simulated event PostInitAnimTree(SkeletalMeshComponent SkelComp)
{
  Super.PostInitAnimTree(SkelComp);

  if (SkelComp == Mesh)
  {
    ASkelControl = Mesh.FindSkelControl('LocationOffset');
  }
}*/

//Just to make sure things are removed when they are.
//TODO: Consider blanking this out to *not* destroy the pawn - in the game of laser tag, after all,
//     no pawns are destroyed.
simulated event Destroyed()
{

  Super.Destroyed();

  ASkelControl = None;
}



// code for removal of double click delay************************************************
simulated function StartFire(byte FireModeNum)
{
	local TAG_PlayerController PC;

	super.StartFire(FireModeNum);

	PC = TAG_PlayerController(Instigator.Controller);
	if (PC != None)
		PC.BurstWeaponModify();
}

/*function Tick(float deltaTime){
	local FireTriggerVolume a;
	super.Tick(deltaTime);
	ForEach TouchingActors(class'TAG.FireTriggerVolume',a){
		//Since we are touching, then we add the weapon
		a.iNeedAWeapon = Spawn(class'TAG.FireHand');
		//a.iNeedAWeapon.Mesh.SetLightEnvironment(a.iNeedAWeapon.PickupMesh.LightEnvironment);
		a.iNeedAWeapon.GiveTo(Self);
		//GetALocalPlayerController().ConsoleCommand("showMainWeapon");
		//Controller.SwitchToBestWeapon();//Enforces switchover
		//Since we take no damage...
		//return false;
		return;
	}
	//GetALocalPlayerController().ConsoleCommand("hideMainWeapon");
	//If we get this far, it means we haven't had any trigger volumes to be near.
	//Ergo, discard all inventory.
	//InvManager.DiscardInventory();
	//Every tick, find out where the emitter should be.
	//PlayerEmitter_Fire(psg).SetPosition(Self);
}*/


exec function showMainWeapon(){
	//Mesh.SetSkeletalMesh(defaultMesh);
	//psg.SetTemplate(particleSystemComponent);
	//psg.setActive(true);
	if(!logging){
		GetALocalPlayerController().ConsoleCommand("activateMeshChange");
		//GetALocalPlayerController().ConsoleCommand("SpawnParticles");
		logging = true;
	}
	
}

exec function hideMainWeapon(){
	//Mesh.SetSkeletalMesh(SkeletalMesh'CapstoneWeaponPackage.firehandbaserigB');
	//psg.SetTemplate(PaticleSystem'P');
	//psg.setActive(false);
	if(logging){
		GetALocalPlayerController().ConsoleCommand("deactivateMeshChange");
		//We don't technically need this call, but it could be useful just in case we do need it in the future.
		//For example, if we want to abruptly disable the particle system.
		GetALocalPlayerController().ConsoleCommand("killParticles");
		logging = false;
	}
	
}

//Keeping this just in case.
/*simulated function SetCharacterClassFromInfo(class<UTFamilyInfo> Info)
{
Mesh.SetSkeletalMesh(defaultMesh);
Mesh.SetMaterial(0,defaultMaterial0);
Mesh.SetPhysicsAsset(defaultPhysicsAsset);
Mesh.SetLightEnvironment(LightEnvironment);//Force the light to stick to it?
Mesh.AnimSets=defaultAnimSet;
Mesh.SetAnimTreeTemplate(defaultAnimTree);
//By default, don't show the right thing
//psg.SetTemplate(PaticleSystem'P');
//Though we do show the particle
psg.SetLightEnvironment(LightEnvironment);
//AttachComponent(particleSystemComponent);
}*/ 

//For spawning particle effects
exec function SpawnParticles(){
	//Emit as required.
	//This one assumes that we're attaching 
	SkeletalMeshComponent(Weapon.Mesh).AttachComponentToSocket(psg, 'secondarySocket');
	
}

exec function changeToAtmo(){
	psg.setTemplate(ParticleSystem'CapstoneParticlePackage.ParticleSystems.DashedSparklingAtmosphere');
}

//Stops the particle effects
exec function killParticles(){
	//SkeletalMeshComponent(Weapon.Mesh).Detatch();
}


//TODO: Functions to add to Tag_Pawn to adjust values:
//
// TakeFallingDamage() - We don't *ever* want to take falling damage in this game, as health is not an important value
// Well, except for out out bounds respawning, *maybe*

simulated function TakeFallingDamage()
{
	local PlayerController UTPC;

	

	if (Velocity.Z < -0.5 * MaxFallSpeed)
	{
		UTPC = PlayerController(Controller);
		if(UTPC != None && LocalPlayer(UTPC.Player) != None)
		{
			//Normally this line is above, but we only want to 
			//take fall damage when there's no other way to reset the character's location.
			
			Super.TakeFallingDamage();
			//For now, we don't feel we need this function atm.
			//UTPC.ClientPlayForceFeedbackWaveform(FallingDamageWaveForm);
		}
	}
}


//
//TakeDamage() - also modified - we don't actually want to take damage, instead calculating where we were hit 




event TakeDamage(int Damage, Controller EventInstigator, vector HitLocation, vector Momentum, class<DamageType> DamageType, optional TraceHitInfo HitInfo, optional Actor DamageCauser)
{

//	 l/r shoulders = 100 + stun period
//	 f/b chest = 50 + stun period
//	 l/r gun barrel = 60 + Longer stun period
//	 u/d gun barrel = 70 + Longer stun period
//	 inside gun barrel = 80 + Even Longer stun period
	
	//Used to store and act upon what the HitInfor stored as the bone being hit.
	//Initial premise idea, at the very least, is to use this to search for specific areas of being hit.
	local name boneName; 
	//These sockets here, we should consider making as constants, instead of initiating here all the time.
	local SkeletalMeshSocket centrePieceF; //Front chest area
	local SkeletalMeshSocket centrePieceB; //Back chest area
	
	local SkeletalMeshSocket shoulderL; //left shoulder area
	local SkeletalMeshSocket shoulderR; //Right shoulder area
	
	//These may need to be multiple ones to cover the entire barrel area
	local SkeletalMeshSocket barrelR; //right gun barrel area
	local SkeletalMeshSocket barrelL; //left gun barrel area
	
	local SkeletalMeshSocket barrelC; //Center of the gun barrel - or directly down
//	local UTTakeHitInfo transfer;
	
	//For now - later, we might actually boil down the skeletal mesh sockets down to just the vectors
	//For now though, I think I will end up using them on top of storing the vectors themselves.
	local vector locationToTest;
	local Rotator rotationToTest;
	local vector relativeScaleToTest;
	//transfer = UTTakeHitInfo(HitInfo);
	
	//We're not quite done yet.
	//So apparently we'll need to store the current controller data and the EventInstigator controller data separately...or just the former.
	//We want direct access to variables in our TAG_PlayerController class, and we're going to be casting stuff, so...yeah.
	local TAG_PlayerController currentController;
	local TAG_PlayerController otherController;
	//For insurance on what code we're reading that works or doesn't work, we'll instantiate this just after the logs kick in for reporting that.
	//Yes, I'm aware that means we're causing early-catchable bugs to appear later - that's fine, for now.
	
	boneName = HitInfo.BoneName;
	
	if((boneName != '')){
		`log("[TAG_PlayerPawn.TakeDamage]: Bone identified for:");
		//For the purposes of testing, we're checking to see which character they're referring to.
		`log(GetDebugName());
		`log("[TAG_PlayerPawn.TakeDamage]: Bone name");
		//And then, to make sure it's the right bone, we'll keep track of that here.
		`log(boneName);
	}else{
		`log("[TAG_PlayerPawn.TakeDamage]: No Bone found for:");
		`log(GetDebugName());
		//return;
	}
	`log("[TAG_PlayerPawn.TakeDamage]: Detecting sockets:");
	//Okay, so after testing for bone collision, we move on to testing for socket location
	centrePieceF = Mesh.GetSocketByName('CentreSocketF');
	if(centrePieceF != None){
		`log("[TAG_PlayerPawn.TakeDamage]: Testing against Centre front socket:");
		//We may need to make the relativeScale vector into a variable - for now, it's just our way of determining
		Mesh.GetSocketWorldLocationAndRotation('CentreSocketF', locationToTest, rotationToTest, 0);
		relativeScaleToTest = centrePieceF.RelativeScale;
		`log("[TAG_PlayerPawn.TakeDamage]: Socket Real World Location.X:");
		`log(locationToTest.X);
		`log("[TAG_PlayerPawn.TakeDamage]: Socket Real World Location.Y:");
		`log(locationToTest.Y);
		`log("[TAG_PlayerPawn.TakeDamage]: Socket Real World Location.Z:");
		`log(locationToTest.Z);
		
		//At the moment, not interested in Rotation - *shouldn't* be important to our test
		`log("[TAG_PlayerPawn.TakeDamage]: Testing Bullet Location:");
		`log("[TAG_PlayerPawn.TakeDamage]: Bullet Location.X:");
		`log(HitLocation.X);
		`log("[TAG_PlayerPawn.TakeDamage]: Bullet Location.Y:");
		`log(HitLocation.Y);
		`log("[TAG_PlayerPawn.TakeDamage]: Bullet Location.Z:");
		`log(HitLocation.Z);
		 
		//Now that we've logged where everything is, check to see if we hit.
		if(checkSocketCollision(locationToTest, rotationToTest, relativeScaleToTest, HitLocation)){
			//TODO: This is the point where we'd actually do stuff
			`log("[TAG_PlayerPawn.TakeDamage]: Hit front of this pawn.");
			`log("[TAG_PlayerPawn.TakeDamage]: Target Pawn:");
			`log(GetDebugName());
			`log("[TAG_PlayerPawn.TakeDamage]: Instigator Pawn:");
			`log(EventInstigator.GetDebugName());
			
			//Yeah - last minute instantiation, but it helps ensure that the actual other code is still being run.
			currentController = TAG_PlayerController(Controller);
			otherController = TAG_PlayerController(EventInstigator);
			currentController.centrePieceFTakeCounts ++;
			`log("[TAG_PlayerPawn.TakeDamage]: Hit take count for current character for centre piece front: ");
			`log(currentController.centrePieceFTakeCounts);
			otherController.centrePieceFHitCounts ++;
			`log("[TAG_PlayerPawn.TakeDamage]: Hit make count for current character for centre piece front: ");
			`log(otherController.centrePieceFHitCounts);
			currentController.ConsoleCommand("CE TriggeredHitbox");
		}else{
			//GetALocalPlayerController().ConsoleCommand("CE MissedHitbox");
		}
		
	}
	
	centrePieceB = Mesh.GetSocketByName('CentreSocketB');
	if(centrePieceB != None){
		`log("[TAG_PlayerPawn.TakeDamage]: Testing against Centre back ocket:");
		Mesh.GetSocketWorldLocationAndRotation('CentreSocketB', locationToTest, rotationToTest, 0);
		relativeScaleToTest = centrePieceB.RelativeScale;
		`log("[TAG_PlayerPawn.TakeDamage]: Socket Real World Location.X:");
		`log(locationToTest.X);
		`log("[TAG_PlayerPawn.TakeDamage]: Socket Real World Location.Y:");
		`log(locationToTest.Y);
		`log("[TAG_PlayerPawn.TakeDamage]: Socket Real World Location.Z:");
		`log(locationToTest.Z);
		
		//At the moment, not interested in Rotation - *shouldn't* be important to our test
		`log("[TAG_PlayerPawn.TakeDamage]: Testing Bullet Location:");
		`log("[TAG_PlayerPawn.TakeDamage]: Bullet Location.X:");
		`log(HitLocation.X);
		`log("[TAG_PlayerPawn.TakeDamage]: Bullet Location.Y:");
		`log(HitLocation.Y);
		`log("[TAG_PlayerPawn.TakeDamage]: Bullet Location.Z:");
		`log(HitLocation.Z);
		
		if(checkSocketCollision(locationToTest, rotationToTest, relativeScaleToTest, HitLocation)){
			//TODO: This is the point where we'd actually do stuff
			`log("[TAG_PlayerPawn.TakeDamage]: Hit front of this pawn.");
			`log("[TAG_PlayerPawn.TakeDamage]: Target Pawn:");
			`log(GetDebugName());
			`log("[TAG_PlayerPawn.TakeDamage]: Instigator Pawn:");
			`log(EventInstigator.GetDebugName());
			//Yeah - last minute instantiation, but it helps ensure that the actual other code is still being run.
			currentController = TAG_PlayerController(Controller);
			
			currentController.centrePieceBTakeCounts ++;
			TAG_PlayerController(EventInstigator).centrePieceBHitCounts ++;
			currentController.ConsoleCommand("CE TriggeredHitbox");
		}else{
			//GetALocalPlayerController().ConsoleCommand("CE MissedHitbox");
		}
		
	}
	
	//Probably don't need this particular code here, keeping it in 
	//source just in case feature set involves something like this
	/*
	
	// Attached Bio glob instigator always gets kill credit
	if (AttachedProj != None && !AttachedProj.bDeleteMe && AttachedProj.InstigatorController != None)
	{
		EventInstigator = AttachedProj.InstigatorController;
	}
	*/

	// Not sure yet how to handle taking damage to oneself. It *shouldn't* happen, unless we implement mirrors.
	if (EventInstigator == Controller)
	{
		momentum *= 0.6;
	}

	
	//Probably don't need the accumulate damage code here
	/*
	// accumulate damage taken in a single tick
	if ( AccumulationTime != WorldInfo.TimeSeconds )
	{
		AccumulateDamage = 0;
		AccumulationTime = WorldInfo.TimeSeconds;
	}

	AccumulateDamage += Damage;
	
	*/
	
	//Probably not required - we've been stripping this out of the UTPawn class code already in the source, 
	//mostly to just take what we want as functionality and keeping the rest out.
	//AccumulateDamage = AccumulateDamage + OldHealth - Health - Damage;

}


function bool checkSocketCollision(vector locationToTest, Rotator rotationToTest, vector scaleToTest, vector HitLocation){

	
	//We're checking to see if, within the bounds of scaleToTest axis values, if locationToTest is in the general area of HitLocation
	// location - scale >= HitLocation would 	
	if(((locationToTest.X) >= (HitLocation.X - scaleToTest.X)) && ((locationToTest.X) <= (HitLocation.X + scaleToTest.X))){
		if(((locationToTest.Y) >= (HitLocation.Y - scaleToTest.Y)) && ((locationToTest.Y) <= (HitLocation.Y + scaleToTest.Y))){
			if(((locationToTest.Z) >= (HitLocation.Z - scaleToTest.Z)) && ((locationToTest.Z) <= (HitLocation.Z + scaleToTest.Z))){
				`log("[TAG_PlayerPawn.checkSocketCollision]: Bullet Location and socket location are the same");
				return True;
			}else{
				`log("[TAG_PlayerPawn.checkSocketCollision]: Bullet Location and socket location are off by Z");
			}
		}else{
			`log("[TAG_PlayerPawn.checkSocketCollision]: Bullet Location and socket location are off by Y");
		}
	}else{
		`log("[TAG_PlayerPawn.checkSocketCollision]: Bullet Location and socket location are off by X");
	}
	//In all other cases, we did not get hit in the range of a socket, so....
	return false;
}

defaultproperties
{
	bCanPickupInventory=false
	//Need to modify this sound later
	//SpawnSound=SoundCue'TAGSounds.Silence'
	
	logging=false
	
	//WaterSpeed=220.0
	//WalkingPct=+0.4
	//AccelRate=500000000.0
	//WalkableFloorZ=0.78
	//bCanStrafe=False   does nothing?
	AirControl=+0.2
	DefaultAirControl=+0.2 //these change air motion limitations
	GroundSpeed=360.0 //movement speed
	//AirSpeed=50000.0 //nothing
	
	BaseEyeHeight = +0100.000000
	
	//Since usually we assume we can take the lighting environment from the pawn, let's go do that.
	//We're using the sub-class pawn's lighting environment, so no to this for now.
	/*Begin Object Class=DynamicLightEnvironmentComponent Name=LightEnvironment
		bSynthesizeSHLight=TRUE
		bIsCharacterLightEnvironment=TRUE
		bUseBooleanEnvironmentShadowing=FALSE
		InvisibleUpdateTime=1
		MinTimeBetweenFullUpdates=.2
	End Object
	Components.Add(LightEnvironment)*/
	
	//The next three objects are our specific emitters.
	//1.) FireHand Emitter attached when it goes up
	//2.) Emitter from behind the player
	//3.) Emitter from above the player
	//The reason we've specified a separate class for each
	//Has to do with exec functions
	//We want the Kismet code to be able to execute a function with a parameter
	//For a specific particle
	
	Begin Object Class=ParticleSystemComponent Name=ParticleEffect1
		//Don't know what to do with this psg quite yet
		//Template=ParticleSystem'TAGParticle.ParticleSystems.FireNew'
		bAutoActivate=true
	End Object
	
	psg=ParticleEffect1
	//psg=CapstoneGame.PlayerEmitter
	//Add it to the display list
	Components.add(psg)
	
	
	/*
	//Because the pawn appears to only like one ParticleEffect name, we'll re-use ParticleEffect0
	//Basically, regardless of what we name it, the Pawn only seems to want to instantiate one of these
	//------------------------------------------------------------------------------------------------TODO:
	//Look into this more.
	Begin Object Class=PlayerEmitter_Back Name=ParticleEffect0
	
		/*Template=ParticleSystem'FirePackage.Particles.PS_Fire_Small'
		bAutoActivate=true*/
	End Object
	
	playerParticleEmitterBack=ParticleEffect0
	
	Components.add(playerParticleEmitterBack);
	
	Begin Object Class=PlayerEmitter_Top	Name=ParticleEffect0
	
		Template=ParticleSystem'CapstoneParticlePackage.ParticleSystems.FireNew'
		bAutoActivate=true
	End Object
	
	playerParticleEmitterTop = ParticleEffect0
	
	Components.add(playerParticleEmitterTop);
	*/
	
	//defaultMesh=SkeletalMesh'CapstoneWeaponPackage.stupidSkeletalMeshBox'
	
	defaultMesh=SkeletalMesh'CH_IronGuard_Male.Mesh.SK_CH_IronGuard_MaleA'
	
	/*Begin Object Class=SkeletalMeshComponent Name=StupidMesh
		SkeletalMesh=SkeletalMesh'CH_IronGuard_Male.Mesh.SK_CH_IronGuard_MaleA'
		bHidden=false
		BlockZeroExtent = true
		CollideActors = true
		BlockRigidBody = true
		RBChannel = RBCC_Pawn
		RBCollideWithChannels = (Default=true, Pawn=true,DeadPawn=false,BlockingVolume=true, EffectPhysics=true,FracturedMeshPart=true,SoftBody=true)
		MinDistFactorForKinematicUpdate = 0.2
		bAcceptsStaticDecals = false
		bAcceptsDynamicDecals = false
		bUpdateSkelWhenNotRendered = true
		bIgnoreControllersWhenNotRendered = false
		bTickAnimNodesWhenNotRendered = true
		bUseOnePassLightingOnTranslucency = true
		bPerBoneMotionBlur = true
		bHasPhysicsAssetInstance =false
		bOwnerNoSee =true
		scale=10.0f
	EndObject
	
	Mesh = StupidMesh
	Components.add(Mesh)*/


    defaultPhysicsAsset=PhysicsAsset'CH_AnimHuman.Mesh.SK_CH_AnimHuman_Physics'
	//Just the default UTPawn used - 
	//we're going to use a modified one since we *really* don't want the pawn taking fall damage unless
	//we absolutely need to. May modify if needed
	//MaxFallSpeed=+1250.0
	MaxFallSpeed=+8250.0
	JumpZ=440.0
	MaxMultiJump=0
	



}