//=============================================================================
// SPG_GameInfo
//
// Game info which spawns the player controller, pawn and HUD for the player.
//
// Copyright 1998-2011 Epic Games, Inc. All Rights Reserved.
//=============================================================================

class TAG_GameInfo extends UTDeathmatch;


//Basically here to 
static event class<GameInfo> SetGameType(string MapName, string Options, string Portal)
{
	return Default.Class;
}


function Tick(float deltaTime){
	WorldInfo.Tick(deltaTime);//Pretend regular tick happens
	//Reset time
	//reset timelimit
	GameReplicationInfo.RemainingTime = 60 * TimeLimit;
	// if the round lasted less than one minute, we won't be actually changing RemainingMinute
	// which will prevent it from being replicated, so in that case
	// reduce the time limit by one second to ensure that it is unique
	if ( GameReplicationInfo.RemainingTime == GameReplicationInfo.RemainingMinute )
	{
		GameReplicationInfo.RemainingTime--;
	}
	GameReplicationInfo.RemainingMinute = GameReplicationInfo.RemainingTime;
}

//Just for us to tell the system that we want the firehand to have a firey texture
exec function activateMeshChange(){
	local Sequence Kismet;
	local array<SequenceObject> Results;
	local int i;
	local array<int> Indices;
	
	//This next bit gets the Kismet nodes from the actual code, and if it finds the right one, activates it.
	Kismet = WorldInfo.GetGameSequence();
	
	Kismet.FindSeqObjectsByClass(class'FireTransitionEvent', true, Results);
	//So now we've loaded Results with SeqObjects with this name, time to trigger them.
	for(i= 0; i<Results.Length; i++)
	{
		`log("[TAG_GameInfo.activateMeshChange]: Found Fire Transition Event - possessing");
		
		`log("[TAG_GameInfo.activateMeshChange] Swap allowed");
		//Probably should make this one function with both active/inactive parts referencing this
		//Instead, this says "Use the first output link"
		Indices[0] = 0;
			
		//We convert the array item to the "FireTransitionEvent" class, then make it activate.
		FireTransitionEvent(Results[i]).CheckActivate(WorldInfo, none, false, Indices, true);
		
		
	}
}

//Just for ust to tell the system to stop doing the firehand firey texture and go back to normal.
exec function deactivateMeshChange(){
	local Sequence Kismet;
	local array<SequenceObject> Results;
	local int i;
	local array<int> Indices;
	
	
	Kismet = WorldInfo.GetGameSequence();
	
	Kismet.FindSeqObjectsByClass(class'FireTransitionEvent', true, Results);
	//So now we've loaded Results with SeqObjects with this name, time to trigger them.
	for(i= 0; i<Results.Length; i++)
	{
		`log("[TAG_GameInfo.deactivateMeshChange]: Found Possession Event - possessing");
		
		`log("[TAG_GameInfo.deactivateMeshChange] Swap allowed");
		//Probably should make this one function with both active/inactive parts referencing this
		//Instead, it just says "Use the second output link."
		Indices[0] = 1;
			
		//We convert the array item to the "RuinationPossessionAct" class, then make it activate.
		FireTransitionEvent(Results[i]).CheckActivate(WorldInfo, none, false, Indices, true);
		
		
	}
	
}


/*function NavigationPoint FindPlayerStart( Controller Player, optional byte InTeam, optional string IncomingName )
{
	local NavigationPoint N, BestStart;
	local Teleporter Tel;

	//Mostly overrriding the funciton in GameInfo
	//And giving us this inserted funciton.
	//Should give us everything we need.
	//We don't want to rank them, because...well, ranking would be useless.
	//We choose one by random.
	BestStart = ChoosePlayerStart(Player, InTeam);
	return BestStart;
}*/

/*function PlayerStart ChoosePlayerStart( Controller Player, optional byte InTeam )
{	
	local Sequence seq;
	local PlayerStart P, BestStart;
	local float BestRating, NewRating;
	local byte Team;
	local array<PlayerStart> playerList;
	local int index;
	local array<SequenceObject> Results;
	// Find best playerstart
	seq = WorldInfo.GetGameSequence();
	seq.FindSeqObjectsByClass(class'SeqVar_Object', true, Results);
	index = 0;
	while(index < Results.Length){
		if(SeqVar_Object(Results[index]).GetObjectValue().class == class'PlayerStart'){
			playerList.addItem(PlayerStart(SeqVar_Object(Results[index]).GetObjectValue()));	
		}
		//This will isolate the player start objects
		index++;
	}

	//foreach WorldInfo.AllNavigationPoints(class'PlayerStart', P)
	//{
	//	playerList.addItem(P);
	//}
	
	index = Rand(playerList.Length-1);
	`log("[Cap_GameInfo] Random index");
	`log(index);
	//Random integer between 0 and the last index of the player starts is chosen.
	//Label that the "Best Start"
	BestStart = playerList[index];

	return BestStart;
}*/


defaultproperties
{
	// What player controller class to create for the player
	PlayerControllerClass=class'TAG_PlayerController'
	DefaultPawnClass=Class'TAG_PlayerPawn'
	// What default pawn archetype to spawn for the player
	//DefaultPawnArchetype=TAG_PlayerPawn'TAGArchtypes.Archetypes.PlayerPawn'
	// What default weapon archetype to spawn for the player
	DefaultWeapon=class'FireHand'
	// What HUD class to create for the player
	//HUDType=class'SPG_HUD'
}