class MSWeapon_Firehand extends MSWeapon;


//For here, we'll specify our own projectile firing
/** overloaded: play fire effects */
simulated function PlayFireEffects(byte FireModeNum, optional vector HitLocation)
{
	Super.PlayFireEffects(FireModeNum, HitLocation);
	//Now we need to explicitly fire the projectile.
	//We don't use FireAmmuniton because it'll loop.
	//And we needed to define this in MSWeapon.
	//FireAmmunition();
	ProjectileFire();
}



/*simulated event vector GetPhysicalStartLoc(optional vector AimDir)
{
	local SkeletalMeshComponent compo;
	local SkeletalMeshSocket socket;
	local vector finalLocation;
	compo = SkeletalMeshComponent(Mesh);
	`log("[MSWeapon_Firehand.GetPhysicalStartLoc] Hey.");
	if(compo != none)
	{
		socket = compo.GetSocketByName('ProjectileSocket');
		
		if(socket != none)
		{
			//The socket needs to take into account offsets for the hand, so...we don't just return the vector
			//return compo.GetBoneLocation(socket.BoneName);
			finalLocation = compo.GetBoneLocation(socket.BoneName);
			finalLocation += ArmViewOffset;//The arm is offset, but the bone location is not.
			//finalLocation += socket.RelativeLocation;//And now the relative offset so it's not directly into the hand.
			`log("[MSWeapon_Firehand.GetPhysicalStartLoc] Returning location.");
			return finalLocation;
		}
	}
}*/



defaultproperties
{
	//mesh settings		//*30    -20
	//FireHandWeapon uses this one
	//ArmViewOffset = (X=0, Y=30, Z=-40)
	//Attempting to use firehandtest2 here. Because we already have animations for this, that's why.
	//Also, it's the right hand instead of the left hand..
						//Default X = 0.0, Y = 30.0, Z =-20.00
	//ArmViewOffset = (X=50.0, Y=40.000000, Z = -40.00)
	ArmViewOffset = (X=30.0, Y=30.000000, Z = -10.00)
	//arms mesh
Begin Object name=ArmsMeshComp
	
	//Old FireHandWeapon
	//SkeletalMesh = SkeletalMesh'CapstoneWeaponPackage.FireHandWeapon'
	
	//leftHand
	//SkeletalMesh = SkeletalMesh'CapstoneWeaponPackage.firehandtest2'
	//Newer SkeletalMesh
	SkeletalMesh = SkeletalMesh'CapstoneWeaponPackage.FireHandWeapon2'
	AnimSets(0)=AnimSet'CapstoneWeaponPackage.Bones'
	
	//Using our actual skeletal mesh.
	//AnimSets(0)=AnimSet'CapstoneWeaponPackage.pasted__bones'
	//AnimSets(0) = AnimSet'CapstoneWeaponPackage.firehandtest2_animset'
	//We do this because the bones are offset at the moment.
	//If we are able to reset the animations one last time, we'll have this working.
	//AnimSets(0) = none;
	//New animation 

	
	Scale = 0.5
	DepthPriorityGroup = SDPG_Foreground
	bOnlyOwnerSee = true
	bOverrideAttachmentOwnerVisibility = true
	CastShadow = false
	FOV = 60.0f
	Animations = MeshSequenceA
	bPerBoneMotionBlur = true
	bAcceptsStaticDecals = false
	bAcceptsDynamicDecals = false
	bUpdateSkelWhenNotRendered = false
	bComponentUseFixedSkelBounds = true
	Rotation=(Roll=0, Pitch=0, Yaw=0)
End Object
Mesh = ArmsMeshComp

ArmIdleAnims(0) = WeaponIdle
ArmEquipAnim = WeaponEquip
ArmFireAnim = WeaponFire
ArmUnEquipAnim= WeaponUnequip
	
	//firearm
	FirearmClass = class'MSFirearm_Firehand'
	
	IronsightViewOffset = (X=47.0)
	AimingMeshFOV = 45.0f
	
	//ironsight
	AimingFOV = 90.0f
	
	//muzzle flash
	MuzzleFlashClass = class 'MSMuzzleFlash_Pistol'
	
	AmmoCount = 10
	MaxAmmoCount = 99
	MagAmmo = 1
	MaxAmmo = 10
	
	//projectile
	WeaponProjectiles(0)=class'FireHandProj' // UTProj_LinkPowerPlasma if linked (see GetProjectileClass() )

}