/**
 * Copyright 1998-2012 Epic Games, Inc. All Rights Reserved.
 */
class FireHandProj extends UTProj_LinkPlasma;

var vector ColorLevel;
var vector ExplosionColor;

var ParticleSystem hitParticle;

simulated function ProcessTouch (Actor Other, vector HitLocation, vector HitNormal)
{
	`log("[CapstoneGame.FireHandProj] ProcessedTouch check");
	if ( Other != Instigator )
	{
		if ( !Other.IsA('Projectile') || Other.bProjTarget )
		{
			`log("[CapstoneGame.FireHandProj] ProcessedTouch hit");
			//Now that we've hit something, change the explosion parameter
			//SetExplosionEffectParameters(hitParticle);
			
			ProjExplosionTemplate = ParticleSystem'CapstoneParticlePackage.ParticleSystems.BurningSmoke-ProjectileExplosion';
			
			MomentumTransfer = (UTPawn(Other) != None) ? 0.0 : 1.0;
			Other.TakeDamage(Damage, InstigatorController, HitLocation, MomentumTransfer * Normal(Velocity), MyDamageType,, self);
			Explode(HitLocation, HitNormal);
		}
	}
}

simulated event HitWall(vector HitNormal, Actor Wall, PrimitiveComponent WallComp)
{
	`log("[CapstoneGame.FireHandProj] HitWall");
	//Now that we've hit something, change the explosion parameter
	//SetExplosionEffectParameters(hitParticle);
	ProjExplosionTemplate = ParticleSystem'CapstoneParticlePackage.ParticleSystems.BurningSmoke-ProjectileExplosion';
	MomentumTransfer = 1.0;

	Super.HitWall(HitNormal, Wall, WallComp);
}

simulated function SpawnFlightEffects()
{
	Super.SpawnFlightEffects();
	`log("[FireHandProj.SpawnFlightEffects] Location parameters");
	`log(Location.X);
	`log(Location.Y);
	`log(Location.Z);
	if (ProjEffects != None)
	{
		ProjEffects.SetVectorParameter('LinkProjectileColor', ColorLevel);
	}
}


simulated function SetExplosionEffectParameters(ParticleSystemComponent ProjExplosion)
{
	Super.SetExplosionEffectParameters(ProjExplosion);
	ProjExplosion.SetVectorParameter('LinkImpactColor', ExplosionColor);
}

function Init(vector Direction)
{
	local vector LocalSocket;
	local vector plusSocket;
	local BOOL isLogging;
	local Rotator ro;
	LocalSocket = Instigator.Mesh.SkeletalMesh.Sockets[0].RelativeLocation;
	
	//isLogging = (SPG_Player_Pawn(Instigator)).logging;
	/*ro.Yaw = 2968;
	ro.Pitch = 6213;
	ro.Roll = 15062;
	
	plusSocket.X = Instigator.Location.X + 0;
	plusSocket.Y = Instigator.Location.Y + 0;
	plusSocket.Z = Instigator.Location.Z + 40;
	if(true){
		`log("[FireHandProj.Init] Locations.X ");
		`log(plusSocket.X);
		`log("[FireHandProj.Init] Locations.Y ");
		`log(plusSocket.Y);
		`log("[FireHandProj.Init] Locations.Z ");
		`log(plusSocket.Z);
		`log("[FireHandProj.Init] Locations.Yaw ");
		`log(ro.Yaw);
		`log("[FireHandProj.Init] Locations.Pitch ");
		`log(ro.Pitch);
		`log("[FireHandProj.Init] Locations.Roll ");
		`log(ro.Roll);
	}
	SetLocation(plusSocket);
	SetRotation(ro);*/
	
	plusSocket.X = Location.X + 0;
	plusSocket.Y = Location.Y + 0;
	plusSocket.Z = Location.Z + 0;
	
	SetRotation(Rotator(Direction));
	SetLocation(plusSocket);

	Velocity = Speed * Direction;
	TossZ = TossZ + (FRand() * TossZ / 2.0) - (TossZ / 4.0);
	Velocity.Z += TossZ;
	Acceleration = AccelRate * Normal(Velocity);
	SetTimer (0.7, false, 'Shutdown');
}


defaultproperties
{
	//ProjFlightTemplate=ParticleSystem'gizm0san_FireTutorial.Particles.PA_Effect_Fire'
	//ProjFlightTemplate=ParticleSystem'FirePackage.Particles.PS_Fire_NEW'
	
	//When in flight
	ProjFlightTemplate=ParticleSystem'CapstoneParticlePackage.ParticleSystems.BurningSmoke-Projectile'
	
	//When hitting thin air
	//TODO: Change this to something not nearly as absurd as the current one.
	ProjExplosionTemplate=ParticleSystem'CapstoneParticlePackage.ParticleSystems.BurningSmoke-ProjectileMidAir'
	
	//When Hitting an object
	//hitProjectile = ParticleSystem'CapstoneParticlePackage.ParticleSystems.BurningSmoke-ProjectileExplosion'
	
	
	ExplosionSound=SoundCue'CapstoneEnvironmentSounds.Silence'
	MaxEffectDistance=50

	Speed=3500//1350//of bullet
	MaxSpeed=3000
	AccelRate=0.0
	//TossZ= 7 //arc Fthrown, low number means faster drop, higher means prolonged drop
	//Physics=PHYS_Falling
	bWaitForEffects= True
	
	/*Begin Object Class=ParticleSystemComponent Name=ParticleEffect1
		Template=ParticleSystem'CapstoneParticlePackage.ParticleSystems.DashedSparklingAtmosphere'
		bAutoActivate=true
	End Object
	
	//ParticleEffect1
	
	handParticle=ParticleEffect1
	Components.Add(handParticle);*/

	Damage=1
	DamageRadius=0
	MomentumTransfer=0
	CheckRadius=26.0

	MyDamageType=class'UTDmgType_LinkPlasma'
	//LifeSpan=0.6// how long the bullet lives for
	NetCullDistanceSquared=+144000000.0

	bCollideWorld=true
	DrawScale=1.2
	logging = false
	ExplosionSound=SoundCue'CapstoneEnvironmentSounds.Silence'
	ColorLevel=(X=1,Y=1.3,Z=1)
	ExplosionColor=(X=1,Y=1,Z=1);
}
