/**
 * Copyright 1998-2012 Epic Games, Inc. All Rights Reserved.
 */
//class FireHand extends UTWeap_LinkGun;
//We got it working in the MSWeapon_FireHand solution, so let's just extend that.
//Credit to Andy for writting that version up.
//Later on, we'll need to clean this up a bit.
class FireHand extends MSWeapon_Firehand;

var MaterialInstanceConstant MaterialInstanced;
var Material BaseMaterialForUse;

var ParticleSystemComponent psga;
var ParticleSystemComponent handParticle;

/**
 * Initialize the weapon
 */
simulated function PostBeginPlay(){
	super.PostBeginPlay();
	SkeletalMeshComponent(Mesh).attachComponentToSocket(handParticle, 'ParticleSocket');
	handParticle.setTemplate(ParticleSystem'CapstoneParticlePackage.ParticleSystems.Firehand_Particle');
}



simulated function TimeWeaponEquipping()
{
    super.TimeWeaponEquipping();
	//SkeletalMeshComponent(Mesh).SetLightEnvironment(Instigator.Mesh.LightEnvironment);
}



//We want to customised these states so that you can fire while equipping.

//Although here, in WeaponFiring, we *do* say "Don't fire if the animation is already running

//if(IsPlayingAnim(ArmFireAnim, false)){


//Here's where we'll check.
//If the animation is already being used, then don't fire.
/** state: active */
simulated state Active
{
	/** begin state */
	simulated function BeginState(name PrevState)
	{
		//playing any animations
		if(IsPlayingAnims())
		{
			//already playing an animation so get the time left and set the timer
			SetTimer(GetAnimTimeLeft(), false, 'PlayIdleAnimation');
		}
		else
		{
			//not playing an anim so play the idle anim
			PlayIdleAnimation();
		}
		super.BeginState(PrevState);
	}
	
	simulated function BeginFire(byte FireModeNum)
	{
		if(!IsPlayingAnim(ArmFireAnim, false)){
			if(HasAmmo(FireModeNum))
			{
				//super.BeginFire(FireModeNum);
				PlayFireEffects(FireModeNum);
			
				if(!HasMagazineAmmo())
				{
					if(HasAnyAmmo() && !IsReloading())
					{
						ReloadWeapon();
					}

				}
			}
		}
		
			
	}
	
	/** end state */
	simulated function EndState(name NextState)
	{
		if(IsTimerActive('PlayIdleAnimation'))
		{
			ClearTimer('PlayIdleAnimation');
		}
		super.EndState(NextState);
	}
	
	/** play idle animation */
	simulated function PlayIdleAnimation()
	{
		local int i;
		
		if(WorldInfo.NetMode != NM_DedicatedServer && ArmIdleAnims.Length > 0)
		{
		//----------------------------------------------------------------------------
		//Why randomised?
			i = Rand(ArmIdleAnims.Length);
			PlayWeaponAnim(ArmIdleAnims[i], ArmIdleAnimRate, true);
		}
	}
	
}



/*********************************************************************************************
 * state WeaponFiring
 * This is the default Firing State.  It's performed on both the client and the server.
 *********************************************************************************************/

simulated state WeaponFiring
{
	simulated event bool IsFiring()
	{
		return true;
	}

	/**
	 * Timer event, call is set up in Weapon::TimeWeaponFiring().
	 * The weapon is given a chance to evaluate if another shot should be fired.
	 * This event defines the weapon's rate of fire.
	 */
	simulated function RefireCheckTimer()
	{
		// if switching to another weapon, abort firing and put down right away
		if( bWeaponPutDown )
		{
			`LogInv("Weapon put down requested during fire, put it down now");
			PutDownWeapon();
			return;
		}

		// If weapon should keep on firing, then do not leave state and fire again.
		if( ShouldRefire() )
		{
			//FireAmmunition();
			return;
		}

		// Otherwise we're done firing
		HandleFinishedFiring();
	}

	simulated event BeginState( Name PreviousStateName )
	{
		`LogInv("PreviousStateName:" @ PreviousStateName);
		// Fire the first shot right away
		//Well, unless we already are firing, then we don't.
		//FireAmmunition();
		TimeWeaponFiring( CurrentFireMode );
		
		
	}

	simulated event EndState( Name NextStateName )
	{
		`LogInv("NextStateName:" @ NextStateName);
		// Set weapon as not firing
		ClearFlashCount();
		ClearFlashLocation();
		ClearTimer( nameof(RefireCheckTimer) );

		NotifyWeaponFinishedFiring( CurrentFireMode );
	}
}


//Here, we don't check if the animation is going - we're just going to fire immediately.

/**
 * State WeaponEquipping
 * The Weapon is in this state while transitioning from Inactive to Active state.
 * Typically, the weapon will remain in this state while its selection animation is being played.
 * While in this state, the weapon cannot be fired.
 */
simulated state WeaponEquipping
{

	simulated event BeginState(Name PreviousStateName)
	{
		`LogInv("");
		TimeWeaponEquipping();
		bWeaponPutDown	= false;
	}

	/** Activate() ignored since already becoming active
	*/
	simulated function Activate()
	{
	}

	simulated event EndState(Name NextStateName)
	{
		`log("[CapstoneGame.FireHand.WeaponEquipping.EndState] Left State");
		ClearTimer('WeaponEquipped');
	}

	simulated function WeaponEquipped()
	{
		if( bWeaponPutDown )
		{
			// if switched to another weapon, put down right away
			PutDownWeapon();
			return;
		}

		GotoState('Active');
	}
	
	//Pulled from Weapon.uc state "Active"
	//Basically, normally the WeaponEquipping doesn't have this defined
	//Which means the event doesn't fire off the fact that the player wants to shoot.
	//However, we've found players tend to be impatient when they get the fire hand.
	//So we'll let them activate these.
	//Test build
	
	simulated function BeginFire(byte FireModeNum)
	{
		//So, because we want to fire, we're stopping the timer from preventing us from doing stuff.
		`log("[CapstoneGame.FireHand.WeaponEquipping.BeginFire]: Trying to fire, but won't");
		ClearTimer('WeaponEquipped');
		//SendToFiringState(FireModeNum);
		//Come on, try to fire, why don't you?
		FireAmmunition();
		//For now, we ignore all the "checks"
		//Should probably look into why this blocks, if it does.
		/*if( !bDeleteMe && Instigator != None )
		{
			Global.BeginFire(FireModeNum);

			// in the active state, fire right away if we have the ammunition
			if( PendingFire(FireModeNum) && HasAmmo(FireModeNum) )
			{
				SendToFiringState(FireModeNum);
			}
		}*/
		GotoState('Active');
		`log("[CapstoneGame.FireHand.WeaponEquipping.BeginFire] Left State");
		
	}

	/**
	 * ReadyToFire() called by NPC firing weapon. bFinished should only be true if called from the Finished() function
 	 */

	simulated function bool ReadyToFire(bool bFinished)
	{
		return true;
	}
	
}

/** overloaded: play fire effects */
simulated function PlayFireEffects(byte FireModeNum, optional vector HitLocation)
{

	local float timeToWait;
	if(ArmFireAnim != '')
	{
		PlayWeaponAnim(ArmFireAnim, ArmFireAnimRate, false);
		
		//fire anim was changed to aim fire so play normal fire anim for the firearm
		if(ArmFireAnim == ArmAimFireAnim)
		{
			timeToWait = PlayWeaponAnim(default.ArmFireAnim,ArmFireAnimRate, false, Firearm.Mesh);
			
		}
		else
		{
			timeToWait = PlayWeaponAnim(ArmFireAnim, ArmFireAnimRate, false, Firearm.Mesh);
		}
		SetTimer(timeToWait +0.70, false, 'PlayIdleAnimation');
	}
	
	//Play muzzle flash
	PlayMuzzleFlashEffect();
	
	//play fire sound
	PlayWeaponSound(FireSound, 1.0);
	ProjectileFire();
}



defaultproperties
{
	//FireOffset=(X=320,Y=100,Z=-10)
	FireInterval(0)=+0.20 //(changes delay on shooting left mouse click)
	FireInterval(1)=+0.35 //(right click fire, currently no action)
	
	

	WeaponProjectiles(0)=class'FireHandProj' // UTProj_LinkPowerPlasma if linked (see GetProjectileClass() )
	WeaponFireTypes(0)=EWFT_Projectile
	
	FireSound = SoundCue'CapstoneEnvironmentSounds.fireball.shootfireCUE'
	//FireSound = SoundCue'CapstoneEnvironmentSounds.fireballCUE'
	EquipSound = SoundCue'CapstoneEnvironmentSounds.Silence'
	UnequipSound = SoundCue'CapstoneEnvironmentSounds.Silence'
	
	Begin Object Class=ParticleSystemComponent Name=ParticleEffect1
		Template=ParticleSystem'CapstoneParticlePackage.ParticleSystems.Firehand_Particle'
		bAutoActivate=true
	End Object
	
	//ParticleEffect1
	
	handParticle=ParticleEffect1
	Components.Add(handParticle);
	

	
	MaterialInstanced = MaterialInstanceConstant'CapstoneWeaponPackage.Materials.handMaterial_INST'
	BaseMaterialForUse = Material'CapstoneWeaponPackage.Materials.handMaterial'
	


}
