package secretsGrabbingPackage;

import java.io.File;
import java.util.Scanner;

/**
 * Because lots of the files need to pull secret file information out (i.e. Database configuration details, apiKeys), 
 * SecretsGrabber handles the code to do the file reading.
 * @author Alexander The 1st
 *
 */
public class SecretsGrabber {
	
	/**
	 * Gets the secret
	 * @param filePath - the filepath that contains the entirety of the secret.
	 * @param keyName - Just for logging purposes to know what key is which key.
	 * @return
	 */
	public static String getSecret(String filePath, String keyName) {
		File apiFile = new File(filePath);
    	Scanner reader = null;
    	StringBuilder apiKeyBuilder = new StringBuilder();
    	try {
    		reader = new Scanner(apiFile);
    		while(reader.hasNextLine()) {
    			apiKeyBuilder.append(reader.nextLine());
    		}
    		
    		
    	}catch(Exception err) {
    		System.out.println("Could not read api secret file at " + filePath  + ": " + err.getMessage());
    	}finally {
    		System.out.println(keyName + " api key: " + apiKeyBuilder.toString());
    		if(reader != null) {
    			try {
    				reader.close();
    			}catch(Exception e) {
    				System.out.println(e.getMessage());
    			}
    		}
    	}
    	return apiKeyBuilder.toString();
	}

}
