package unit;

import java.awt.Image;
import java.awt.image.ImageObserver;

import buntil.ILoader;

import gUI.PirateNinjaBoxerPanel;
import gUI.Camera;
import gUI.MoveTimer;
import coords.Coords;

public class Hero extends Unit{
	public String status = null;
	
	public Hero(Coords placementa, PirateNinjaBoxerPanel aP, String idP, Image[] apa)
	{
		super(placementa, aP, "Hero", idP, apa);
	}
	public void move() 
	{
		super.move();
		if(path[path.length-1] == placement)
		{
			if(status == "MovingRight")
			{
				status = "StoppedRight";
			}else if (status == "MovingLeft")
			{
				status = "StoppedLeft";
			}
			
		}else if(path[path.length-1].getX() >= placement.getX())
		{
			status = "MovingRight";
		}
		else if(path[path.length-1].getX() <= placement.getX())
		{
			status = "MovingLeft";
		}
	}
	public Image[] checkStatusImages(Image[] imagea, ImageObserver iO)
	{
		Image[] newa = imagea.clone();
		if(status == "StoppedRight")
		{
			Image[] toss = {imagea[0], imagea[1], imagea[2]};			
			//If more images, take away
			newa = toss;
		}else if(status == "StoppedLeft")
		{
			Image[] toss = {imagea[0], imagea[1], imagea[2]};
			toss = ILoader.flip(toss, iO);
			//If more images, take away
			newa = toss;
		}else if (status == "MovingRight")
		{
			Image[] toss = {imagea[3], imagea[4], imagea[5], imagea[6], imagea[7]};
			// If more images, add imagea[5], imagea[6], imagea[7]
			newa = toss;
		}else if (status == "MovingLeft")
		{
			Image[] toss = {imagea[3], imagea[4], imagea[5], imagea[6], imagea[7]};
			toss = ILoader.flip(toss, iO);
			// If more images, add imagea[5], imagea[6], imagea[7]
			newa = toss;
		}
		
		return newa;
	}
	public void paintComponent(java.awt.Graphics2D bB, PirateNinjaBoxerPanel iO, Image[] imagea, Camera viewer)
	{
		super.paintComponent(bB, iO, checkStatusImages(imagea, iO), viewer);
	}
}
