package unit;

import java.awt.Image;
import java.awt.image.ImageObserver;

import buntil.ILoader;

import scenery.Scenery;

import gUI.PirateNinjaBoxerPanel;
import gUI.Camera;
import gUI.MoveTimer;
import coords.CharaPath;
import coords.Coords;

public class Enemy extends Unit {
	public String direction = "forward";
	public CharaPath farview;
	public Coords farLeft, farRight;
	public double forwardDist, otherDist;
	public Coords currentPosition;
	public boolean flip = false;
	
	public Enemy(Coords placementa, String idP, Image[] apa, Coords endPath)
	{
		super(placementa, "Enemy", idP, apa);
                //We need to eventually de-tangle the code here                                                                                                                                  
		super.developPath(endPath.getX(), endPath.getY(), this.placement.getX(), this.placement.getY(), new Scenery[0], new Camera(new Coords(0, 0, 0), PirateNinjaBoxerPanel.aPa));
		forwardDist = this.bounda.rect.getWidth()*5;
		otherDist = (this.bounda.rect.getHeight());
		if(endPath.getX() > placementa.getX())
		{
			flip = true;
		}
		
//		for(int a = 0; a<path.length; a++)
//		{
//			System.out.println(path[a].getX() + " : " + path[a].getY());
//		}
	}
        
        public Enemy(Coords placementa, String idP, Coords endPath)
	{
		super(placementa, "Enemy", idP);
                //We need to eventually de-tangle the code here                                                                                                                                  
		super.developPath(endPath.getX(), endPath.getY(), this.placement.getX(), this.placement.getY(), new Scenery[0], new Camera(new Coords(0, 0, 0), PirateNinjaBoxerPanel.aPa));
		forwardDist = this.bounda.rect.getWidth()*5;
		otherDist = (this.bounda.rect.getHeight());
		if(endPath.getX() > placementa.getX())
		{
			flip = true;
		}
		
//		for(int a = 0; a<path.length; a++)
//		{
//			System.out.println(path[a].getX() + " : " + path[a].getY());
//		}
	}
	
	public void move() 
	{
		if((pathplace < path.length -1) && (direction == "forward"))
		{
			super.move();
		}else if ((pathplace == path.length -1) && (direction == "forward"))
		{
			super.move();
			pathplace --;
			direction = "backwards";
			reverseFlip();
		}else if ((pathplace > 0) && (direction == "backwards"))
		{
			super.unMove();
		}else if((pathplace == 0) && (direction == "backwards"))
		{
			super.unMove();
			pathplace ++;
			direction = "forward";
			reverseFlip();
		}
		
//		if(path[path.length-1] == placement)
//		{
//			if(status == "MovingRight")
//			{
//				status = "StoppedRight";
//			}else if (status == "MovingLeft")
//			{
//				status = "StoppedLeft";
//			}
//			
//		}else if(path[path.length-1].getX() >= placement.getX())
//		{
//			status = "MovingRight";
//		}
//		else if(path[path.length-1].getX() <= placement.getX())
//		{
//			status = "MovingLeft";
//		}
	}
	public boolean getView(PirateNinjaBoxerPanel aP)
	{
		if(flip == false)
		{
			farLeft = new Coords(this.bounda.getHalfXBound() - forwardDist, this.bounda.getHalfYBound() + otherDist);
			farRight = new Coords(this.bounda.getHalfXBound()  - forwardDist, this.bounda.getHalfYBound() - otherDist);
			farview = new CharaPath(farLeft, farRight, this);
			currentPosition = new Coords(this.bounda.getHalfXBound(), this.bounda.getHalfYBound());
			Coords lastPosition;
			for(int a = 0; a<farview.getPath().length; a++)
			{
				lastPosition = new Coords(farview.getPath()[a]);
				boolean alert = (new CharaPath(currentPosition, lastPosition, this)).checkPath(aP.heroes, aP.barriers);
				if(alert)
				{
					return true;
				}
			}
		
		}else if(flip)
		{
			farLeft = new Coords(this.bounda.getHalfXBound() + forwardDist, this.bounda.getHalfYBound() - otherDist);
			farRight = new Coords(this.bounda.getHalfXBound()  + forwardDist, this.bounda.getHalfYBound() + otherDist);
			farview = new CharaPath(farLeft, farRight, this);
			currentPosition = new Coords(this.bounda.getHalfXBound(), this.bounda.getHalfYBound());
			Coords lastPosition;
			for(int a = 0; a<farview.getPath().length; a++)
			{
				lastPosition = new Coords(farview.getPath()[a]);
				boolean alert = (new CharaPath(currentPosition, lastPosition, this)).checkPath(aP.heroes, aP.barriers);
				if(alert)
				{
					return true;
				}
			}
		}
		return false;
	}

	public void paintComponent(java.awt.Graphics2D bB, PirateNinjaBoxerPanel iO, Image[] imagea, Camera viewer)
	{
		super.paintComponent(bB, iO, checkStatusImages(imagea, iO), viewer);
	}
	
	public Image[] checkStatusImages(Image[] imagea, ImageObserver iO)
	{
            if(imagear == null){
                return new Image[0];
            }
		Image[] newa = imagea.clone();
		if(flip == false)
		{
			Image[] toss = {imagea[0], imagea[1], imagea[2]};			
			//If more images, take away
			
			newa = toss;
		}else if(flip)
		{
			Image[] toss = {imagea[0], imagea[1], imagea[2]};
			toss = ILoader.flip(toss, iO);
			//If more images, take away
			newa = toss;
		}
//		}else if (status == "MovingRight")
//		{
//			Image[] toss = {imagea[0], imagea[1], imagea[2]};
//			toss = ILoader.flip(toss, iO);
//			// If more images, add imagea[5], imagea[6], imagea[7]
//			newa = toss;
//		}else if (status == "MovingLeft")
//		{
//			Image[] toss = {imagea[0], imagea[1], imagea[2]};
//			
//			// If more images, add imagea[5], imagea[6], imagea[7]
//			newa = toss;
//		}
		
		return newa;
	}
	public void reverseFlip()
	{
		if(flip)
		{
			flip = false;
			return;
		}
		flip = true;
		return;
	}
}
