package coords;
import gUI.Camera;

import scenery.Scenery;
import unit.Unit;

public class CharaPath extends Path{
	
	//Enter the superconstructors!
	public CharaPath(int[] x, int[] y, Unit currentUnit)
	{
		super(x, y);
		super.setPath((double)currentUnit.getMoveLen());
	}
	
	public CharaPath(int[] x, int[] y, int[] z, Unit currentUnit)
	{
		super(x, y, z);
		super.setPath((double)currentUnit.getMoveLen());
	}
	public CharaPath(int[] x, int[] y, int[] z, int[] h, Unit currentUnit)
	{
		super(x, y, z, h);
		super.setPath((double)currentUnit.getMoveLen());
	}
	
	public CharaPath(double[] x, double[] y, Unit currentUnit)
	{
		super(x, y);
		super.setPath((double)currentUnit.getMoveLen());
	}
	public CharaPath(double[] x, double[] y, double[] z, Unit currentUnit)
	{
		super(x, y, z);
		super.setPath((double)currentUnit.getMoveLen());
	}
	public CharaPath(double[] x, double[] y, double[] z, double[] h, 
			Unit currentUnit, Scenery[] objects, Camera viewer)
	{
		super(x, y, z, h);
		super.setPath((double)currentUnit.getMoveLen());
		this.checkPath(currentUnit, objects);
	}
	public CharaPath(int[][]coords, Unit currentUnit)
	{
		super(coords);
		super.setPath((double)currentUnit.getMoveLen());
	}
	
	public CharaPath(double[][]coords, Unit currentUnit)
	{
		super(coords);
		super.setPath((double)currentUnit.getMoveLen());
	}
	public CharaPath(Coords[] coords, Unit currentUnit)
	{
		super(coords);
		super.setPath((double)currentUnit.getMoveLen());
	}
	public CharaPath(Coords lastplacement, Coords coords, Unit unit)
	{
		super(lastplacement, coords);
		super.setPath((double)unit.getMoveLen());
	}
	//End of constructors - NOTE: Due to lack of willingness, 
	//I am assuming that if you use one type, you will consistently 
	//use that type for the constructor.
	//Simply speaking, I am un-willing to make every single possible
	//combination of each constructor - if you're waiting for that, 
	//go read a book or something; it could be a while.

	

	public void checkPath(Unit currentUnit, Scenery[] objects)
	{
//		Path modified;
		Coords[] modified;
		int a = 0;
		while (a<path.length)
		{
			boolean inWay = false;
			for (int b = 0; b<objects.length; b++)
			{
				if ((objects[b].bounda.rect.contains(path[a].getX(), path[a].getY())) || ((objects[b].bounda.rect.contains(path[a].getX() - currentUnit.bounda.rect.width, path[a].getY()))))
				{//Above checks to see if the coordinate on the path is inside the bounding box of an enemy.
					inWay = true;
					break;
//					System.out.println(path[a].getX() + " : " + path[a].getY() + " Is in " + objects[b].iDP);
//					objects[b].bounda.setOUBounds((int)currentUnit.getMoveLen(), path, a-1);
//					Coords[] overBounds = objects[b].bounda.getOverBounds();
//					Coords[] underBounds = objects[b].bounda.getUnderBounds();
//					Coords[] newpoints1 = overBounds;
//					Coords[] newpoints2 = underBounds;
//					if(newpoints1.length <= newpoints2.length)
//					{
//						modified = new Path(newpoints1);//If so, it will create a path that goes behind the enemy.
//					}else
//					{
//						modified = new Path(newpoints2);
//					}
//					modified.setPath(currentUnit.getMoveLen());//Creates a curved path of sorts.
//					a = reDoPath(currentUnit, modified, a-1);
					
				}
			}
			if(inWay)
			{
				modified = new Coords[a];
				for(int c = 0; c<a; c++)
				{
					modified[c] = path[c];
				}
				path = modified;
				break;
			}
			a++;
			
		}
		
	}
	
	public boolean checkPath(Unit[] enemies, Scenery[] objects)
	{
		int a = 0;
		while (a<path.length)
		{
			for (int b = 0; b<enemies.length; b++)
			{
				if ((path[a].getX() >= enemies[b].bounda.getLeftBound()) && (path[a].getX() <= enemies[b].bounda.getRightBound())
						&& (path[a].getY() >= enemies[b].bounda.getUpBound()) && (path[a].getY() <= enemies[b].bounda.getLowBound()))
				{//Above checks to see if the coordinate on the path is inside the bounding box of an enemy.
					return true;					
				}
			}
			for (int b = 0; b<objects.length; b++)
			{
				if ((objects[b].bounda.rect.contains(path[a].getX(), path[a].getY())) || ((objects[b].bounda.rect.contains(path[a].getX(), path[a].getY()))))
				{//Above checks to see if the coordinate on the path is inside the bounding box of an enemy.
					return false;
				}
			}
			a++;
			
		}
		return false;
	}
	
	public int reDoPath(Unit currentUnit, Path modified, int a)
	{
		int c = a;
		while(c<path.length)
		{//Here we replace the current path's co-ords that go through the enemy with this set.
			
			if (c-a < modified.getPath().length)
			{
				path[c] = modified.getPath()[c-a];
			}else if (c-a >= modified.getPath().length)
			{
				Path toss = new Path(path[c-a], path[path.length-1]);
				toss.setPath(currentUnit.getMoveLen());
				for (int r = c; r<toss.getPath().length +c; r++)
				{
					path[c] = toss.getPath()[r-c];
				}
				return c;
			}
			
		}
		return c;
	}
}
