package bounds;
import coords.*;

import java.awt.Image;
import java.awt.Rectangle;
import unit.Unit;
import scenery.Scenery;
import unit.ID;
import gUI.Camera;

public class Bounds {
	
	public Rectangle rect;
	private Coords[] oBound, cBound;
	public ID obj; //Keeps track of what object it is bounding - used later on.
	
	public Bounds(Unit un)
	
	{
		double x = un.placement.getX();
		double y = un.placement.getY();
		double width = un.width;
		double height = un.height;
		rect = new Rectangle((int)x, (int)y, (int)width, (int)height);
		obj = un;
	}
	
public Bounds(Unit un, Image[] apa)
	
	{
		double x = un.placement.getX();
		double y = un.placement.getY();
		double width = un.width;
		double height = un.height;
		java.awt.Graphics g = apa[0].getGraphics();
		g.clipRect((int)x, (int)y, (int)width, (int)height);
		rect = g.getClipBounds();
		//rect = new Rectangle((int)x, (int)y, (int)width, (int)height);
		obj = un;
	}
	
	public Bounds(Scenery sc)
	{
		double x = sc.placement.getX();
		double y = sc.placement.getY();
		double width = sc.width;
		double height = sc.height;
		rect = new Rectangle((int)x, (int)y, (int)width, (int)height);
		obj = sc;
	}
	
//	public Bounds(Coords cM, gUI.PirateNinjaBoxerPanel pP)
//	{
//		rect.setBounds((int)cM.getX(), 
//				(int)cM.getY(), 
//				pP.WIDTH, 
//				pP.HEIGHT);
//		obj = pP.viewer;
//	}
	//Constructors above for either Scenery or Unit.
	
	public Bounds(Coords coords, int i, int j) {
		rect = new Rectangle((int)coords.getX(), (int)coords.getY(), i, j);
		obj = new ID("Completion", "Completion", "Completion");
	}

	public double getLeftBound()
	{
		return (double)rect.getX();
	}
	public double getRightBound()
	{
		return (double)(rect.getX() + rect.width);
	}
	public double getUpBound()
	{
		return (double)(rect.getY());
	}
	public double getLowBound()
	{
		return (double)(rect.getY() + rect.height);
	}

	public double getHalfXBound()
	{
		return (double) (this.getRightBound() - rect.width/2);
	}
	public double getHalfYBound()
	{
		return (double) (this.getLowBound() - rect.height/2);
	}

	public boolean setOUBounds(int mL, Coords[] path, int index)
	{
		Coords topLeft = new Coords(this.getLeftBound(), this.getUpBound());
		Coords topRight = new Coords(this.getRightBound(), this.getUpBound());
		Coords bottomLeft = new Coords(this.getLeftBound(), this.getLowBound());
		Coords bottomRight = new Coords(this.getRightBound(), this.getLowBound());		
		Coords topHalf = new Coords(this.getHalfXBound(), this.getUpBound() - mL);
		Coords bottomHalf = new Coords(this.getHalfXBound(), this.getUpBound() + mL);
		Coords leftHalf = new Coords(this.getLeftBound() - mL, this.getHalfYBound());
		Coords rightHalf = new Coords(this.getRightBound() + mL, this.getHalfYBound());

		if(obj.iD == "Ellipse")
		{

		}else if (obj.iD == "Square")
		{
			topLeft.addToPart(-mL, "x");
			topLeft.addToPart(-mL, "y");
			topRight.addToPart(mL, "x");
			topRight.addToPart(-mL, "y");
			bottomLeft.addToPart(-mL, "x");
			bottomLeft.addToPart(mL, "y");
			bottomRight.addToPart(mL, "x");
			bottomRight.addToPart(mL, "y");
			topHalf.addToPart(-mL, "y");
			bottomHalf.addToPart(mL, "y");
			leftHalf.addToPart(-mL, "x");
			rightHalf.addToPart(mL, "x");
		}
		if(path[index].getX() <= getLeftBound())
		{
			Coords[] to = {topLeft, topHalf, topRight};
			oBound = to;
			Coords[] ao = {bottomLeft, bottomHalf, bottomRight};
			cBound = ao;
			return true;

		}else if (path[index].getX() >= getRightBound()) //Elsewise if on the other side, right to left
		{
			Coords[] to = {topRight, topHalf, topLeft};
			oBound = to;
			Coords[] ao = {bottomRight, bottomHalf, bottomLeft};
			cBound = ao;
			return true;
			
		}else if (path[index].getY() <= getUpBound()) //Elsewise, it must be below this object that we have collision
		{
			Coords[] to = {topRight, rightHalf, bottomRight};
			oBound = to;
			Coords[] ao = {topLeft, leftHalf, bottomLeft};
			cBound = ao;
			return true;
			
		}else if (path[index].getY() >= getLowBound())  //No? Then you must be below. There - finito.	
		{
			Coords[] to = {topLeft, leftHalf, bottomLeft};
			oBound = to;
			Coords[] ao = {topRight, rightHalf, bottomRight};
			cBound = ao;
			return true;
			
		}
		return false;


	}
	
	public Coords[] getOverBounds()
	{
		return oBound;
	}
	public Coords[] getUnderBounds()
	{
		return cBound;
	}
//	
//	
//	
//	
//	
	//
	
	//
	//
	
	//
	//
	//
	//
	//
	//
	//
	//
	//
	//
	//
	//
	//
//Nowhere near done.	
	//Gets the rectangular

//   	for (int b = 0; b<objects.length; b++)
//	{
//		if ((path[a].getX() >= objects[b].getLeftBound()) && (path[a].getX() <= objects[b].getRightBound())
//				&& (path[a].getY() >= objects[b].getUpBound()) && (path[a].getY() <= objects[b].getLowBound()))
//		{//Above checks to see if the coordinate on the path is inside the bounding box of an enemy.
//			objects[b].setOUBounds(currentUnit.getMoveLen(), path, a-1);
//			Coords[] OverBounds = objects[b].getOverBounds();
//			Coords[] UnderBounds = objects[b].getUnderBounds();
//			Coords[] newpoints1 = OverBounds;
//			Coords[] newpoints2 = UnderBounds;
//			if(newpoints1.length <= newpoints2.length)
//			{
//				modified = new Path(newpoints1);//If so, it will create a path that goes behind the enemy.
//			}else
//			{
//				modified = new Path(newpoints2);
//			}
//			modified.setPath(currentUnit.getMoveLen());//Creates a curved path of sorts.
//			a = reDoPath(currentUnit, modified, a);

	
}
