/*
 * Decompiled with CFR 0.152.
 */
package unit;

import buntil.ILoader;
import coords.CharaPath;
import coords.Coords;
import gUI.Camera;
import gUI.PirateNinjaBoxerPanel;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.ImageObserver;
import unit.Unit;

public class Enemy
extends Unit {
    public String direction = "forward";
    public CharaPath farview;
    public Coords farLeft;
    public Coords farRight;
    public double forwardDist;
    public double otherDist;
    public Coords currentPosition;
    public boolean isFlipped = false;

    public Enemy(Coords placementa, PirateNinjaBoxerPanel aP, String idP, Image[] apa, Coords endPath) {
        super(placementa, aP, "Enemy", idP, apa);
        super.developPath(endPath.getX(), endPath.getY(), this.placement.getX(), this.placement.getY(), aP.barriers, aP.panelView);
        this.forwardDist = this.boundary.rect.getWidth() * 5.0;
        this.otherDist = this.boundary.rect.getHeight();
        if (endPath.getX() > placementa.getX()) {
            this.isFlipped = true;
        }
    }

    @Override
    public void move() {
        if (this.pathPlace < this.path.length - 1 && this.direction == "forward") {
            super.move();
        } else if (this.pathPlace == this.path.length - 1 && this.direction == "forward") {
            super.move();
            --this.pathPlace;
            this.direction = "backwards";
            this.reverseFlip();
        } else if (this.pathPlace > 0 && this.direction == "backwards") {
            super.unMove();
        } else if (this.pathPlace == 0 && this.direction == "backwards") {
            super.unMove();
            ++this.pathPlace;
            this.direction = "forward";
            this.reverseFlip();
        }
    }

    public boolean getView(PirateNinjaBoxerPanel aP) {
        block5: {
            block4: {
                if (this.isFlipped) break block4;
                this.farLeft = new Coords(this.boundary.getHalfXBound() - this.forwardDist, this.boundary.getHalfYBound() + this.otherDist);
                this.farRight = new Coords(this.boundary.getHalfXBound() - this.forwardDist, this.boundary.getHalfYBound() - this.otherDist);
                this.farview = new CharaPath(this.farLeft, this.farRight, (Unit)this);
                this.currentPosition = new Coords(this.boundary.getHalfXBound(), this.boundary.getHalfYBound());
                int a = 0;
                while (a < this.farview.getPath().length) {
                    Coords lastPosition = new Coords(this.farview.getPath()[a]);
                    boolean alert = new CharaPath(this.currentPosition, lastPosition, (Unit)this).checkPath(aP.heroes, aP.barriers);
                    if (alert) {
                        return true;
                    }
                    ++a;
                }
                break block5;
            }
            if (!this.isFlipped) break block5;
            this.farLeft = new Coords(this.boundary.getHalfXBound() + this.forwardDist, this.boundary.getHalfYBound() - this.otherDist);
            this.farRight = new Coords(this.boundary.getHalfXBound() + this.forwardDist, this.boundary.getHalfYBound() + this.otherDist);
            this.farview = new CharaPath(this.farLeft, this.farRight, (Unit)this);
            this.currentPosition = new Coords(this.boundary.getHalfXBound(), this.boundary.getHalfYBound());
            int a = 0;
            while (a < this.farview.getPath().length) {
                Coords lastPosition = new Coords(this.farview.getPath()[a]);
                boolean alert = new CharaPath(this.currentPosition, lastPosition, (Unit)this).checkPath(aP.heroes, aP.barriers);
                if (alert) {
                    return true;
                }
                ++a;
            }
        }
        return false;
    }

    @Override
    public void paintComponent(Graphics2D bB, ImageObserver iO, Image[] imagea, Camera viewer) {
        super.paintComponent(bB, iO, this.checkStatusImages(imagea, iO), viewer);
    }

    public Image[] checkStatusImages(Image[] imagea, ImageObserver iO) {
        Image[] newa = (Image[])imagea.clone();
        if (!this.isFlipped) {
            Image[] toss = new Image[]{imagea[0], imagea[1], imagea[2]};
            newa = toss;
        } else if (this.isFlipped) {
            Image[] toss = new Image[]{imagea[0], imagea[1], imagea[2]};
            toss = ILoader.flip(toss, iO);
            newa = toss;
        }
        return newa;
    }

    public void reverseFlip() {
        if (this.isFlipped) {
            this.isFlipped = false;
            return;
        }
        this.isFlipped = true;
    }
}

