/*
 * Decompiled with CFR 0.152.
 */
package gUI;

import bounds.Bounds;
import coords.CharaPath;
import coords.Coords;
import gUI.Camera;
import gUI.FortressSneaker;
import gUI.MoveTimer;
import gUI.Mover;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPanel;
import scenery.Scenery;
import sound.Sound;
import unit.Boxer;
import unit.Enemy;
import unit.Gunner;
import unit.Ninja;
import unit.Pirate;
import unit.Unit;

public class PirateNinjaBoxerPanel
extends JPanel
implements Mover,
KeyListener,
MouseListener,
MouseMotionListener {
    private static final long serialVersionUID = 3596988778581506192L;
    private final int INIT_X = 100;
    private final int INIT_Y = 100;
    private final int INTERVAL = 100;
    public int cameraScroll = 10;
    public int farRight;
    public int farDown;
    public Camera panelView;
    public Unit currentUseUnit;
    public Unit[] heroes;
    public Enemy[] theFortressEnemies;
    public Scenery[] barriers;
    public MoveTimer _timer;
    public Font text = new Font(null, 1, 18);
    private boolean gameover = false;
    private boolean complete = false;
    public FortressSneaker _frame;
    public AudioClip aC;
    public int level;
    public Bounds completionMarker;

    public PirateNinjaBoxerPanel(FortressSneaker framea, int levela, String charactera) {
        this._frame = framea;
        this._frame.setTitle("Fortress Sneaker Level " + levela);
        this.setDoubleBuffered(true);
        this._timer = new MoveTimer(100, this);
        this.level = levela;
        this.farRight = 600 * this.level;
        this.farDown = 600 * this.level;
        this.completionMarker = new Bounds(new Coords(this.farRight - 100, this.farDown - 100), 100, 100);
        this.heroes = new Unit[1];
        this.theFortressEnemies = new Enemy[(int)Math.pow(2.0, this.level)];
        this.barriers = new Scenery[(int)Math.pow(2.0, this.level)];
        this.panelView = new Camera(new Coords(0, 0), this);
        if (charactera == "Pirate") {
            // empty if block
        }
        this.currentUseUnit = new Pirate(new Coords(100, 400), this);
        if (charactera == "Boxer") {
            this.currentUseUnit = new Boxer(new Coords(100, 400), this);
        } else if (charactera == "Ninja") {
            this.currentUseUnit = new Ninja(new Coords(100, 400), this);
        }
        this.heroes[0] = this.currentUseUnit;
        int a = 0;
        while (a < this.barriers.length) {
            double squareOrEllipse = Math.random();
            double randomX = Math.random() * (double)this.farRight - 100.0;
            while (randomX <= 100.0) {
                randomX = Math.random() * (double)this.farRight - 100.0;
            }
            double randomY = Math.random() * (double)this.farDown - 100.0;
            if (squareOrEllipse <= 0.5) {
                this.barriers[a] = new Scenery("Square", new Coords(randomX, randomY), this);
            } else if (squareOrEllipse > 0.5) {
                this.barriers[a] = new Scenery("Ellipse", new Coords(randomX, randomY), this);
            }
            ++a;
        }
        a = 0;
        while (a < this.theFortressEnemies.length) {
            double randomX = Math.random() * (double)this.farRight - 100.0;
            double randomY = Math.random() * (double)this.farDown - 100.0;
            double randomX2 = Math.random() * (double)this.farRight - 100.0;
            double randomY2 = Math.random() * (double)this.farDown - 100.0;
            CharaPath toss = new CharaPath(new Coords(randomX, randomY), new Coords(randomX2, randomY2), this.currentUseUnit);
            toss.checkPath(this.currentUseUnit, this.barriers, this.panelView);
            while (toss.getPath().length > 50) {
                randomX2 = Math.random() * (double)this.farRight - 100.0;
                randomY2 = Math.random() * (double)this.farDown - 100.0;
                toss = new CharaPath(new Coords(randomX, randomY), new Coords(randomX2, randomY2), this.currentUseUnit);
                toss.checkPath(this.currentUseUnit, this.barriers, this.panelView);
            }
            this.theFortressEnemies[a] = new Gunner(new Coords(randomX, randomY), new Coords(randomX2, randomY2), this);
            ++a;
        }
        this.setBackground(Color.DARK_GRAY);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        try {
            this.aC = Sound.getSound("pkmz.wav");
            this.aC.loop();
        }
        catch (OutOfMemoryError e) {
            try {
                System.gc();
                framea.wait(5000L);
                this.aC = Sound.getSound("pkmz.wav");
                this.aC.loop();
            }
            catch (OutOfMemoryError e1) {
                Runtime.getRuntime().exit(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this._timer.restart();
    }

    @Override
    public void move() {
        try {
            if (this.gameover || this.complete) {
                this._timer.stop();
                return;
            }
            int a = 0;
            while (a < this.heroes.length) {
                this.heroes[a].move();
                if (this.completionMarker.rect.contains(this.heroes[a].placement.getX(), this.heroes[a].placement.getY())) {
                    this.complete = true;
                    this.aC.stop();
                }
                ++a;
            }
            int b = 0;
            while (b < this.theFortressEnemies.length) {
                this.theFortressEnemies[b].move();
                boolean alert = this.theFortressEnemies[b].getView(this);
                if (alert) {
                    this.gameover = true;
                    this.aC.stop();
                }
                ++b;
            }
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void paintComponent(Graphics aBrush) {
        super.paintComponent(aBrush);
        Graphics2D betterBrush = (Graphics2D)aBrush;
        betterBrush.setFont(this.text);
        betterBrush.setColor(Color.CYAN);
        betterBrush.fillRect((int)((double)this.completionMarker.rect.x - this.panelView.getX()), (int)((double)this.completionMarker.rect.y - this.panelView.getY()), this.completionMarker.rect.width, this.completionMarker.rect.height);
        betterBrush.setColor(Color.BLUE);
        int a = 0;
        while (a < this.barriers.length) {
            this.barriers[a].paintComponent(betterBrush, this, this.panelView);
            ++a;
        }
        a = 0;
        while (a < this.heroes.length) {
            this.heroes[a].paintComponent(betterBrush, this, this.heroes[a].imagear, this.panelView);
            ++a;
        }
        a = 0;
        while (a < this.theFortressEnemies.length) {
            this.theFortressEnemies[a].paintComponent(betterBrush, this, this.theFortressEnemies[a].imagear, this.panelView);
            ++a;
        }
        if (this.gameover) {
            this.updateUI();
            this.repaint();
            betterBrush.setColor(Color.orange);
            betterBrush.drawString("Game Over.", this.getWidth() / 2 - this.getWidth() / this.text.getSize(), this.getHeight() / 2);
            betterBrush.drawString("Press 'Enter' to replay.", this.getWidth() / 2 - this.getWidth() / this.text.getSize(), this.getHeight() / 2 + this.text.getSize());
        }
        if (this.complete) {
            this.updateUI();
            this.repaint();
            betterBrush.setColor(Color.orange);
            betterBrush.drawString("Complete.", this.getWidth() / 2 - this.getWidth() / this.text.getSize(), this.getHeight() / 2);
            betterBrush.drawString("Press 'Enter' to continue.", this.getWidth() / 2 - this.getWidth() / this.text.getSize(), this.getHeight() / 2 + this.text.getSize());
        }
    }

    public double getLeftBound() {
        return this.getX();
    }

    public double getRightBound() {
        return this.getX() + this.farRight;
    }

    public double getUpBound() {
        return this.getY();
    }

    public double getLowBound() {
        return this.getY() + this.farDown;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void keyPressed(KeyEvent e) {
        try {
            String charactera;
            if (e.getKeyCode() != 10) {
                if (e.getKeyCode() != 27) return;
                this.aC.stop();
                String charactera2 = this.heroes[0].realID;
                this.readyForGarbageCollection();
                this._frame = new FortressSneaker("Fortress Sneaker Level", this.level, charactera2);
                return;
            }
            if (this.complete) {
                charactera = this.heroes[0].realID;
                this.readyForGarbageCollection();
                this._frame = new FortressSneaker("Fortress Sneaker Level", this.level + 1, charactera);
            }
            if (this.gameover) {
                charactera = this.heroes[0].realID;
                this.readyForGarbageCollection();
                this._frame = new FortressSneaker("Fortress Sneaker Level", this.level, charactera);
                return;
            }
            if (this._timer.isRunning()) {
                this._timer.stop();
                return;
            }
            this._timer.start();
            return;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            this.currentUseUnit.developPath((double)e.getX() + this.panelView.getX(), (double)e.getY() + this.panelView.getY(), this.currentUseUnit.placement.getX(), this.currentUseUnit.placement.getY(), this.barriers, this.panelView);
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (e.getX() < 100) {
            this.panelView.moveLeft();
        } else if (e.getX() > 500) {
            this.panelView.moveRight();
        }
        if (e.getY() < 100) {
            this.panelView.moveUp();
        } else if (e.getY() > 500) {
            this.panelView.moveDown();
        } else {
            return;
        }
    }

    public void readyForGarbageCollection() {
        int a = 0;
        while (a < this.barriers.length) {
            this.barriers[a].placement = null;
            this.barriers[a].boundary = null;
            this.barriers[a].personalPanel = null;
            this.barriers[a].generalID = null;
            this.barriers[a].realID = null;
            this.barriers[a].typeID = null;
            this.barriers[a] = null;
            ++a;
        }
        int b = 0;
        while (b < this.heroes.length) {
            this.heroes[b].placement = null;
            this.heroes[b].boundary = null;
            this.heroes[b].personalPanel = null;
            this.heroes[b].generalID = null;
            this.heroes[b].realID = null;
            this.heroes[b].typeID = null;
            this.heroes[b].imagear = null;
            this.heroes[b].lastplacement = null;
            this.heroes[b].path = null;
            this.heroes[b] = null;
            ++b;
        }
        int c = 0;
        while (c < this.theFortressEnemies.length) {
            this.theFortressEnemies[c].placement = null;
            this.theFortressEnemies[c].boundary = null;
            this.theFortressEnemies[c].personalPanel = null;
            this.theFortressEnemies[c].generalID = null;
            this.theFortressEnemies[c].realID = null;
            this.theFortressEnemies[c].typeID = null;
            this.theFortressEnemies[c].imagear = null;
            this.theFortressEnemies[c].lastplacement = null;
            this.theFortressEnemies[c].path = null;
            this.theFortressEnemies[c] = null;
            ++c;
        }
        this._timer = null;
        this.barriers = null;
        this.heroes = null;
        this.completionMarker = null;
        this.currentUseUnit = null;
        this.theFortressEnemies = null;
        this.panelView = null;
        this.text = null;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.aC = null;
        this.removeAll();
        this._frame.setVisible(false);
        FortressSneaker.theApp = null;
        this._frame.removeAll();
        this._frame.dispose();
        this._frame = null;
        System.gc();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }
}

