/*
 * Decompiled with CFR 0.152.
 */
package coords;

import coords.Coords;

public class Path {
    private Coords[] firstpoints = new Coords[2];
    public Coords[] path;
    private double backgroundlayer = 0.0;
    private double defaultlayer = this.backgroundlayer + 1.0;
    private double h = 1.0;

    public Path(int[] x, int[] y) {
        Coords[] toss = new Coords[x.length];
        int a = 0;
        while (a < x.length) {
            toss[a] = new Coords((double)x[a], (double)y[a], this.defaultlayer, this.h);
            ++a;
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(int[] x, int[] y, int[] z) {
        Coords[] toss = new Coords[x.length];
        int a = 0;
        while (a < x.length) {
            toss[a] = new Coords((double)x[a], (double)y[a], (double)z[a], this.h);
            ++a;
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(int[] x, int[] y, int[] z, int[] h) {
        Coords[] toss = new Coords[x.length];
        int a = 0;
        while (a < x.length) {
            toss[a] = new Coords(x[a], y[a], z[a], h[a]);
            ++a;
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(double[] x, double[] y) {
        Coords[] toss = new Coords[x.length];
        int a = 0;
        while (a < x.length) {
            toss[a] = new Coords(x[a], y[a], this.defaultlayer, this.h);
            ++a;
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(double[] x, double[] y, double[] z) {
        Coords[] toss = new Coords[x.length];
        int a = 0;
        while (a < x.length) {
            toss[a] = new Coords(x[a], y[a], z[a], this.h);
            ++a;
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(double[] x, double[] y, double[] z, double[] h) {
        Coords[] toss = new Coords[x.length];
        int a = 0;
        while (a < x.length) {
            toss[a] = new Coords(x[a], y[a], z[a], h[a]);
            ++a;
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(int[][] coords) {
        Coords[] toss = new Coords[coords.length];
        int a = 0;
        while (a < coords.length) {
            toss[a] = new Coords(coords[a]);
            ++a;
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(double[][] coords) {
        Coords[] toss = new Coords[coords.length];
        int a = 0;
        while (a < coords.length) {
            toss[a] = new Coords(coords[a]);
            ++a;
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(Coords coords1, Coords coords2) {
        this.firstpoints[0] = new Coords(coords1);
        this.firstpoints[1] = new Coords(coords2);
        this.path = this.firstpoints;
    }

    public Path(Coords[] coords) {
        Coords[] toss = new Coords[coords.length];
        int a = 0;
        while (a < toss.length) {
            toss[a] = new Coords(coords[a]);
            ++a;
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Coords[] getPath() {
        return this.path;
    }

    public void setPath(int userMoveLen) {
        int timesToMove = (int)(this.distance() / (double)userMoveLen);
        if (timesToMove == 0) {
            return;
        }
        this.path = this.beizercurve(this.firstpoints, timesToMove);
        System.out.println("Done");
    }

    public void setPath(double userMoveLen) {
        int timesToMove = (int)(this.distance() / userMoveLen);
        if (timesToMove == 0) {
            return;
        }
        this.path = this.beizercurve(this.firstpoints, timesToMove);
    }

    public double distance(Coords point1, Coords point2) {
        double x = Math.abs(point2.getX() / point2.getH() - point1.getX() / point1.getH());
        double y = Math.abs(point2.getY() / point2.getH() - point1.getY() / point1.getH());
        double z = Math.abs(point2.getZ() / point2.getH() - point1.getZ() / point1.getH());
        double dist = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
        return dist;
    }

    public double distance() {
        double a = 0.0;
        int b = 0;
        while (b < this.firstpoints.length - 1) {
            a += this.distance(this.firstpoints[b], this.firstpoints[b + 1]);
            ++b;
        }
        return a;
    }

    public Coords[] beizercurve(Coords[] points, int tm) {
        Coords[] npoints = new Coords[tm + 1];
        int a = 0;
        while (a <= tm) {
            double fraction = (double)a / (double)tm;
            npoints[a] = this.deCasteljau(points, fraction)[0];
            ++a;
        }
        return npoints;
    }

    public Coords[] deCasteljau(Coords[] points, double fractionOfLen) {
        Coords[] newa = this.do_deCast(points, fractionOfLen);
        while (newa.length > 1) {
            newa = this.do_deCast(newa, fractionOfLen);
        }
        return newa;
    }

    public Coords[] do_deCast(Coords[] points, double fractionOfLen) {
        Coords[] newa = new Coords[points.length - 1];
        int a = 0;
        while (a < points.length - 1) {
            newa[a] = this.linInterpt(points[a], points[a + 1], fractionOfLen);
            ++a;
        }
        return newa;
    }

    public Coords linInterpt(Coords point1, Coords point2, double fractionOfLen) {
        double pointi = (1.0 - fractionOfLen) * (point1.getX() / point1.getH()) + fractionOfLen * (point2.getX() / point2.getH());
        double pointj = (1.0 - fractionOfLen) * (point1.getY() / point1.getH()) + fractionOfLen * (point2.getY() / point2.getH());
        double pointk = (1.0 - fractionOfLen) * (point1.getY() / point1.getH()) + fractionOfLen * (point2.getZ() / point2.getH());
        return new Coords(pointi, pointj, pointk);
    }

    public int[] pascals_ans(int o) {
        int[] pasca = new int[]{1};
        if (o != 0) {
            int a = 0;
            while (a < o - 1) {
                pasca = this.pascals_increment(pasca);
                ++a;
            }
        }
        return pasca;
    }

    public int[] pascals_increment(int[] list) {
        int[] pas = (int[])list.clone();
        pas[0] = 1;
        int instance = 0;
        while (instance < list.length - 1) {
            pas[instance + 1] = list[instance] + list[instance + 1];
            ++instance;
        }
        pas[list.length] = 1;
        return pas;
    }
}

