/*
 * Decompiled with CFR 0.152.
 */
package coords;

public class Coords {
    private double x;
    private double y;
    private double x0;
    private double y0;
    private double z0;
    private double h0;
    private double xr;
    private double yr;
    private double zr;
    private double hr;
    private double z = 0.0;
    private double h = 1.0;

    public Coords(int x1, int y1) {
        this.x = x1;
        this.y = y1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(int x1, int y1, int z1) {
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(int x1, int y1, int z1, int h1) {
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.h = h1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(double x1, double y1) {
        this.x = x1;
        this.y = y1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(double x1, double y1, double z1) {
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(double x1, double y1, double z1, double h1) {
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.h = h1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(int[] cords) {
        this.x = cords[0];
        this.y = cords[1];
        this.x0 = this.x;
        this.y0 = this.y;
        if (cords.length > 2) {
            this.z = cords[2];
            if (cords.length > 3) {
                this.h = cords[3];
            }
        }
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(double[] cords) {
        this.x = cords[0];
        this.y = cords[1];
        this.x0 = this.x;
        this.y0 = this.y;
        if (cords.length > 2) {
            this.z = cords[2];
            if (cords.length > 3) {
                this.h = cords[3];
            }
        }
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(Coords coo) {
        this.x = coo.getX();
        this.y = coo.getY();
        this.z = coo.getZ();
        this.h = coo.getH();
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getH() {
        return this.h;
    }

    public double[] getCoords() {
        double[] coords = new double[]{this.x, this.y, this.z, this.h};
        return coords;
    }

    public boolean addToPart(double addition, String part) {
        this.xr = this.x;
        this.yr = this.y;
        this.zr = this.z;
        this.hr = this.h;
        if (part == "x") {
            this.x += addition;
            return true;
        }
        if (part == "y") {
            this.y += addition;
            return true;
        }
        if (part == "z") {
            this.z += addition;
            return true;
        }
        if (part == "h") {
            this.h += addition;
            return true;
        }
        return false;
    }

    public boolean multiplyToPart(double multiple, String part) {
        this.xr = this.x;
        this.yr = this.y;
        this.zr = this.z;
        this.hr = this.h;
        if (part == "x") {
            this.x *= multiple;
            return true;
        }
        if (part == "y") {
            this.y *= multiple;
            return true;
        }
        if (part == "z") {
            this.z *= multiple;
            return true;
        }
        if (part == "h") {
            this.h *= multiple;
            return true;
        }
        return false;
    }

    public boolean changePart(double changeTo, String part) {
        this.xr = this.x;
        this.yr = this.y;
        this.zr = this.z;
        this.hr = this.h;
        if (part == "x") {
            this.x = changeTo;
            return true;
        }
        if (part == "y") {
            this.y = changeTo;
            return true;
        }
        if (part == "z") {
            this.z = changeTo;
            return true;
        }
        if (part == "h") {
            this.h = changeTo;
            return true;
        }
        return false;
    }

    public boolean changeAll(Coords next) {
        try {
            this.xr = this.x;
            this.yr = this.y;
            this.zr = this.z;
            this.hr = this.h;
            this.x = next.getX();
            this.y = next.getY();
            this.z = next.getZ();
            this.h = next.getH();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean rollback() {
        try {
            this.x = this.xr;
            this.y = this.yr;
            this.z = this.zr;
            this.h = this.hr;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean reset() {
        try {
            this.x = this.x0;
            this.y = this.y0;
            this.z = this.z0;
            this.h = this.h0;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

