/*
 * Decompiled with CFR 0.152.
 */
package coords;

import coords.Coords;
import coords.Path;
import gUI.Camera;
import scenery.Scenery;
import unit.Unit;

public class CharaPath
extends Path {
    public CharaPath(int[] x, int[] y, Unit currentUnit) {
        super(x, y);
        super.setPath(currentUnit.getMoveLen());
    }

    public CharaPath(int[] x, int[] y, int[] z, Unit currentUnit) {
        super(x, y, z);
        super.setPath(currentUnit.getMoveLen());
    }

    public CharaPath(int[] x, int[] y, int[] z, int[] h, Unit currentUnit) {
        super(x, y, z, h);
        super.setPath(currentUnit.getMoveLen());
    }

    public CharaPath(double[] x, double[] y, Unit currentUnit) {
        super(x, y);
        super.setPath(currentUnit.getMoveLen());
    }

    public CharaPath(double[] x, double[] y, double[] z, Unit currentUnit) {
        super(x, y, z);
        super.setPath(currentUnit.getMoveLen());
    }

    public CharaPath(double[] x, double[] y, double[] z, double[] h, Unit currentUnit, Scenery[] objects, Camera viewer) {
        super(x, y, z, h);
        super.setPath(currentUnit.getMoveLen());
        this.checkPath(currentUnit, objects, viewer);
    }

    public CharaPath(int[][] coords, Unit currentUnit) {
        super(coords);
        super.setPath(currentUnit.getMoveLen());
    }

    public CharaPath(double[][] coords, Unit currentUnit) {
        super(coords);
        super.setPath(currentUnit.getMoveLen());
    }

    public CharaPath(Coords[] coords, Unit currentUnit) {
        super(coords);
        super.setPath(currentUnit.getMoveLen());
    }

    public CharaPath(Coords lastplacement, Coords coords, Unit unit) {
        super(lastplacement, coords);
        super.setPath(unit.getMoveLen());
    }

    public void checkPath(Unit currentUnit, Scenery[] objects, Camera viewer) {
        int a = 0;
        while (a < this.path.length) {
            boolean inWay = false;
            int b = 0;
            while (b < objects.length) {
                if (objects[b].boundary.rect.contains(this.path[a].getX(), this.path[a].getY()) || objects[b].boundary.rect.contains(this.path[a].getX() - (double)currentUnit.boundary.rect.width, this.path[a].getY())) {
                    inWay = true;
                    break;
                }
                ++b;
            }
            if (inWay) {
                Coords[] modified = new Coords[a];
                int c = 0;
                while (c < a) {
                    modified[c] = this.path[c];
                    ++c;
                }
                this.path = modified;
                break;
            }
            ++a;
        }
    }

    public boolean checkPath(Unit[] enemies, Scenery[] objects) {
        int a = 0;
        while (a < this.path.length) {
            int b = 0;
            while (b < enemies.length) {
                if (this.path[a].getX() >= enemies[b].boundary.getLeftBound() && this.path[a].getX() <= enemies[b].boundary.getRightBound() && this.path[a].getY() >= enemies[b].boundary.getUpBound() && this.path[a].getY() <= enemies[b].boundary.getLowBound()) {
                    return true;
                }
                ++b;
            }
            b = 0;
            while (b < objects.length) {
                if (objects[b].boundary.rect.contains(this.path[a].getX(), this.path[a].getY()) || objects[b].boundary.rect.contains(this.path[a].getX(), this.path[a].getY())) {
                    return false;
                }
                ++b;
            }
            ++a;
        }
        return false;
    }

    public int reDoPath(Unit currentUnit, Path modified, int a) {
        int c = a;
        while (c < this.path.length) {
            if (c - a < modified.getPath().length) {
                this.path[c] = modified.getPath()[c - a];
                continue;
            }
            if (c - a < modified.getPath().length) continue;
            Path toss = new Path(this.path[c - a], this.path[this.path.length - 1]);
            toss.setPath(currentUnit.getMoveLen());
            int r = c;
            while (r < toss.getPath().length + c) {
                this.path[c] = toss.getPath()[r - c];
                ++r;
            }
            return c;
        }
        return c;
    }
}

