/*
 * Decompiled with CFR 0.152.
 */
package gUI;

import bounds.Bounds;
import coords.Coords;
import coords.DCoords;
import gUI.Camera;
import gUI.CombatModel;
import gUI.FortressSneaker;
import gUI.MoveTimer;
import gUI.Mover;
import java.applet.AudioClip;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import scenery.Scenery;
import sounda.Sound;
import unit.Enemy;
import unit.Unit;

public class PirateNinjaBoxerPanel
extends JPanel
implements Mover,
KeyListener,
MouseListener,
MouseMotionListener,
Observer {
    private static final long serialVersionUID = 3596988778581506192L;
    public static PirateNinjaBoxerPanel aPa = null;
    private final int INIT_X = 100;
    private final int INIT_Y = 100;
    private final int INTERVAL = 100;
    public int cameraScroll = 10;
    public int farRight;
    public int farDown;
    public Camera viewer;
    public Unit currentUseUnit;
    public Unit[] heroes;
    public Enemy[] numbers;
    public Scenery[] barriers;
    public MoveTimer _timer;
    public Font text = new Font(null, 1, 18);
    private boolean gameover = false;
    private boolean complete = false;
    public FortressSneaker _frame;
    public AudioClip aC;
    public int level;
    public Bounds bounda;
    public CombatModel obsA;

    public PirateNinjaBoxerPanel(FortressSneaker framea, int levela) {
        this._frame = framea;
        this._frame.setTitle("Fortress Sneaker Level " + levela);
        this.setDoubleBuffered(true);
        this._timer = new MoveTimer(100, this);
        this.setSize(400, 400);
        this.level = levela;
        this.farRight = 600 * this.level;
        this.farDown = 600 * this.level;
        this.bounda = new Bounds(new Coords(this.farRight - 100, this.farDown - 100), 100, 100);
        this.heroes = new Unit[1];
        this.numbers = new Enemy[(int)Math.pow(2.0, this.level)];
        this.barriers = new Scenery[(int)Math.pow(2.0, this.level)];
        this.viewer = new Camera(new Coords(0, 0), this);
        DCoords something = new DCoords(10, 20, 0, 1, (Coords)new DCoords(100, 100, 0, 1, new Coords(0, 0, 0, 1)));
        this.heroes[0] = this.currentUseUnit = new Unit((Coords)something, this, "a", "b");
        this.setBackground(Color.DARK_GRAY);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.aC = Sound.getSound("pkmz.wav");
        this.repaint();
    }

    public PirateNinjaBoxerPanel(FortressSneaker framea, int levela, CombatModel obs) {
        this._frame = framea;
        this.setDoubleBuffered(true);
        this._timer = new MoveTimer(100, this);
        this.obsA = obs;
        obs.addObserver(this);
        this.setSize(400, 400);
        this.level = levela;
        this.farRight = 600 * this.level;
        this.farDown = 600 * this.level;
        this.bounda = new Bounds(new Coords(this.farRight - 100, this.farDown - 100), 100, 100);
        this.viewer = new Camera(new Coords(0, 0), this);
        this.currentUseUnit = this.obsA.currentUseUnit;
        this.heroes = this.obsA.heroes;
        this.barriers = this.obsA.barriers;
        this.numbers = this.obsA.numbers;
        this.setBackground(Color.DARK_GRAY);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.aC = Sound.getSound("pkmz.wav");
        this.repaint();
    }

    @Override
    public void move() {
        try {
            if (this.gameover || this.complete) {
                this._timer.stop();
                return;
            }
            for (int a = 0; a < this.heroes.length; ++a) {
                this.heroes[a].move();
                if (!this.bounda.rect.contains(this.heroes[a].placement.getX(), this.heroes[a].placement.getY())) continue;
                this.complete = true;
                this.aC.stop();
            }
            for (int b = 0; b < this.numbers.length; ++b) {
                this.numbers[b].move();
                boolean alert = this.numbers[b].getView(this);
                if (!alert) continue;
                this.gameover = true;
                this.aC.stop();
            }
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void paintComponent(Graphics aBrush) {
        int a;
        super.paintComponent(aBrush);
        Graphics2D betterBrush = (Graphics2D)aBrush;
        betterBrush.setFont(this.text);
        betterBrush.setColor(Color.CYAN);
        betterBrush.fillRect((int)((double)this.bounda.rect.x - this.viewer.getX()), (int)((double)this.bounda.rect.y - this.viewer.getY()), this.bounda.rect.width, this.bounda.rect.height);
        betterBrush.setColor(Color.BLUE);
        for (a = 0; a < this.barriers.length; ++a) {
            this.barriers[a].paintComponent(betterBrush, this, this.viewer);
        }
        for (a = 0; a < this.heroes.length; ++a) {
            this.heroes[a].paintComponent(betterBrush, this, this.heroes[a].imagear, this.viewer);
        }
        for (a = 0; a < this.numbers.length; ++a) {
            this.numbers[a].paintComponent(betterBrush, this, this.numbers[a].imagear, this.viewer);
        }
        if (this.gameover) {
            this.updateUI();
            this.repaint();
            betterBrush.setColor(Color.orange);
            betterBrush.drawString("Game Over.", this.getWidth() / 2 - this.getWidth() / this.text.getSize(), this.getHeight() / 2);
            betterBrush.drawString("Press 'Enter' to replay.", this.getWidth() / 2 - this.getWidth() / this.text.getSize(), this.getHeight() / 2 + this.text.getSize());
        }
        if (this.complete) {
            this.updateUI();
            this.repaint();
            betterBrush.setColor(Color.orange);
            betterBrush.drawString("Complete.", this.getWidth() / 2 - this.getWidth() / this.text.getSize(), this.getHeight() / 2);
            betterBrush.drawString("Press 'Enter' to continue.", this.getWidth() / 2 - this.getWidth() / this.text.getSize(), this.getHeight() / 2 + this.text.getSize());
        }
    }

    public double getLeftBound() {
        return this.getX();
    }

    public double getRightBound() {
        return this.getX() + this.farRight;
    }

    public double getUpBound() {
        return this.getY();
    }

    public double getLowBound() {
        return this.getY() + this.farDown;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void keyPressed(KeyEvent e) {
        try {
            if (e.getKeyCode() != 10) {
                if (e.getKeyCode() != 27) return;
                this.readyforGarbageCollection();
                this._frame = new FortressSneaker("Fortress Sneaker Level", this.level, this.obsA);
                return;
            }
            if (this.complete) {
                this.readyforGarbageCollection();
                this._frame = new FortressSneaker("Fortress Sneaker Level", this.level + 1, this.obsA);
            }
            if (this.gameover) {
                this.readyforGarbageCollection();
                this._frame = new FortressSneaker("Fortress Sneaker Level", this.level, this.obsA);
                return;
            }
            if (this._timer.isRunning()) {
                this._timer.stop();
                return;
            }
            this._timer.start();
            return;
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        try {
            this.currentUseUnit.developPath((double)e.getX() + this.viewer.getX(), (double)e.getY() + this.viewer.getY(), this.currentUseUnit.placement.getX(), this.currentUseUnit.placement.getY(), this.barriers, this.viewer);
            this.repaint();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void readyforGarbageCollection() {
        for (int a = 0; a < this.barriers.length; ++a) {
            this.barriers[a].placement = null;
            this.barriers[a].bounda = null;
            this.barriers[a].iD = null;
            this.barriers[a].iDP = null;
            this.barriers[a].iDR = null;
        }
        for (int b = 0; b < this.heroes.length; ++b) {
            this.heroes[b].placement = null;
            this.heroes[b].bounda = null;
            this.heroes[b].iD = null;
            this.heroes[b].iDP = null;
            this.heroes[b].iDR = null;
            this.heroes[b].imagear = null;
            this.heroes[b].lastplacement = null;
            this.heroes[b].path = null;
        }
        for (int c = 0; c < this.numbers.length; ++c) {
            this.numbers[c].placement = null;
            this.numbers[c].bounda = null;
            this.numbers[c].iD = null;
            this.numbers[c].iDP = null;
            this.numbers[c].iDR = null;
            this.numbers[c].imagear = null;
            this.numbers[c].lastplacement = null;
            this.numbers[c].path = null;
        }
        this._timer = null;
        this.barriers = null;
        this.heroes = null;
        this.bounda = null;
        this.currentUseUnit = null;
        this.numbers = null;
        this.viewer = null;
        this.text = null;
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        this.aC = null;
        this.removeAll();
        this._frame.setVisible(false);
        this._frame.removeKeyListener(this._frame.bP);
        this._frame.bP = null;
        this._frame.removeAll();
        this._frame.dispose();
        this._frame = null;
        System.gc();
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int movementButton = e.getButton();
        if (movementButton == 1) {
            this.obsA.rotateLocallyPart(180, "z");
        } else {
            this.obsA.rollback();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void update(Observable o, Object arg) {
        System.out.println("Has been picked up: " + new Integer(this.level).toString());
        this.currentUseUnit = this.obsA.currentUseUnit;
        this.heroes = this.obsA.heroes;
        this.barriers = this.obsA.barriers;
        this.numbers = this.obsA.numbers;
        System.out.println("Updated");
        this.repaint();
    }
}

