/*
 * Decompiled with CFR 0.152.
 */
package coords;

import coords.Coords;

public class Path {
    private Coords[] firstpoints = new Coords[2];
    public Coords[] path;
    private double backgroundlayer = 0.0;
    private double defaultlayer = this.backgroundlayer + 1.0;
    private double h = 1.0;

    public Path(int[] x, int[] y) {
        Coords[] toss = new Coords[x.length];
        for (int a = 0; a < x.length; ++a) {
            toss[a] = new Coords((double)x[a], (double)y[a], this.defaultlayer, this.h);
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(int[] x, int[] y, int[] z) {
        Coords[] toss = new Coords[x.length];
        for (int a = 0; a < x.length; ++a) {
            toss[a] = new Coords((double)x[a], (double)y[a], (double)z[a], this.h);
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(int[] x, int[] y, int[] z, int[] h) {
        Coords[] toss = new Coords[x.length];
        for (int a = 0; a < x.length; ++a) {
            toss[a] = new Coords(x[a], y[a], z[a], h[a]);
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(double[] x, double[] y) {
        Coords[] toss = new Coords[x.length];
        for (int a = 0; a < x.length; ++a) {
            toss[a] = new Coords(x[a], y[a], this.defaultlayer, this.h);
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(double[] x, double[] y, double[] z) {
        Coords[] toss = new Coords[x.length];
        for (int a = 0; a < x.length; ++a) {
            toss[a] = new Coords(x[a], y[a], z[a], this.h);
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(double[] x, double[] y, double[] z, double[] h) {
        Coords[] toss = new Coords[x.length];
        for (int a = 0; a < x.length; ++a) {
            toss[a] = new Coords(x[a], y[a], z[a], h[a]);
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(int[][] coords) {
        Coords[] toss = new Coords[coords.length];
        for (int a = 0; a < coords.length; ++a) {
            toss[a] = new Coords(coords[a]);
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(double[][] coords) {
        Coords[] toss = new Coords[coords.length];
        for (int a = 0; a < coords.length; ++a) {
            toss[a] = new Coords(coords[a]);
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Path(Coords coords1, Coords coords2) {
        this.firstpoints[0] = new Coords(coords1);
        this.firstpoints[1] = new Coords(coords2);
        this.path = this.firstpoints;
    }

    public Path(Coords[] coords) {
        Coords[] toss = new Coords[coords.length];
        for (int a = 0; a < toss.length; ++a) {
            toss[a] = new Coords(coords[a]);
        }
        this.firstpoints = toss;
        this.path = this.firstpoints;
    }

    public Coords[] getPath() {
        return this.path;
    }

    public void setPath(int userMoveLen) {
        int timesToMove = (int)(this.distance() / (double)userMoveLen);
        if (timesToMove == 0) {
            return;
        }
        this.path = this.beizercurve(this.firstpoints, timesToMove);
        System.out.println("Done");
    }

    public void setPath(double userMoveLen) {
        int timesToMove = (int)(this.distance() / userMoveLen);
        if (timesToMove == 0) {
            return;
        }
        this.path = this.beizercurve(this.firstpoints, timesToMove);
    }

    public double distance(Coords point1, Coords point2) {
        double x = Math.abs(point2.getX() / point2.getH() - point1.getX() / point1.getH());
        double y = Math.abs(point2.getY() / point2.getH() - point1.getY() / point1.getH());
        double z = Math.abs(point2.getZ() / point2.getH() - point1.getZ() / point1.getH());
        double dist = Math.sqrt(Math.pow(x, 2.0) + Math.pow(y, 2.0) + Math.pow(z, 2.0));
        return dist;
    }

    public double distance() {
        double a = 0.0;
        for (int b = 0; b < this.firstpoints.length - 1; ++b) {
            a += this.distance(this.firstpoints[b], this.firstpoints[b + 1]);
        }
        return a;
    }

    public Coords[] beizercurve(Coords[] points, int tm) {
        Coords[] npoints = new Coords[tm + 1];
        for (int a = 0; a <= tm; ++a) {
            double fraction = (double)a / (double)tm;
            npoints[a] = this.deCasteljau(points, fraction)[0];
        }
        return npoints;
    }

    public Coords[] deCasteljau(Coords[] points, double fractionOfLen) {
        Coords[] newa = this.do_deCast(points, fractionOfLen);
        while (newa.length > 1) {
            newa = this.deCasteljau(newa, fractionOfLen);
        }
        return newa;
    }

    public Coords[] do_deCast(Coords[] points, double fractionOfLen) {
        Coords[] newa = new Coords[points.length - 1];
        for (int a = 0; a < points.length - 1; ++a) {
            newa[a] = this.linInterpt(points[a], points[a + 1], fractionOfLen);
        }
        return newa;
    }

    public Coords linInterpt(Coords point1, Coords point2, double fractionOfLen) {
        double pointi = (1.0 - fractionOfLen) * (point1.getX() / point1.getH()) + fractionOfLen * (point2.getX() / point2.getH());
        double pointj = (1.0 - fractionOfLen) * (point1.getY() / point1.getH()) + fractionOfLen * (point2.getY() / point2.getH());
        double pointk = (1.0 - fractionOfLen) * (point1.getY() / point1.getH()) + fractionOfLen * (point2.getZ() / point2.getH());
        return new Coords(pointi, pointj, pointk);
    }

    public int[] pascals_ans(int o) {
        int[] pasca = new int[]{1};
        if (o != 0) {
            for (int a = 0; a < o - 1; ++a) {
                pasca = this.pascals_increment(pasca);
            }
        }
        return pasca;
    }

    public int[] pascals_increment(int[] list) {
        int[] pas = (int[])list.clone();
        pas[0] = 1;
        for (int instance = 0; instance < list.length - 1; ++instance) {
            pas[instance + 1] = list[instance] + list[instance + 1];
        }
        pas[list.length] = 1;
        return pas;
    }
}

