/*
 * Decompiled with CFR 0.152.
 */
package coords;

public class Coords {
    protected double x;
    protected double y;
    protected double x0;
    protected double y0;
    protected double z0;
    protected double h0;
    protected double xr;
    protected double yr;
    protected double zr;
    protected double hr;
    protected double z = 0.0;
    protected double h = 1.0;

    public Coords(int x1, int y1) {
        this.x = x1;
        this.y = y1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(int x1, int y1, int z1) {
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(int x1, int y1, int z1, int h1) {
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.h = h1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(double x1, double y1) {
        this.x = x1;
        this.y = y1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(double x1, double y1, double z1) {
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(double x1, double y1, double z1, double h1) {
        this.x = x1;
        this.y = y1;
        this.z = z1;
        this.h = h1;
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(int[] cords) {
        this.x = cords[0];
        this.y = cords[1];
        this.x0 = this.x;
        this.y0 = this.y;
        if (cords.length > 2) {
            this.z = cords[2];
            if (cords.length > 3) {
                this.h = cords[3];
            }
        }
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(double[] cords) {
        this.x = cords[0];
        this.y = cords[1];
        this.x0 = this.x;
        this.y0 = this.y;
        if (cords.length > 2) {
            this.z = cords[2];
            if (cords.length > 3) {
                this.h = cords[3];
            }
        }
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public Coords(Coords coo) {
        this.x = coo.getX();
        this.y = coo.getY();
        this.z = coo.getZ();
        this.h = coo.getH();
        this.x0 = this.x;
        this.y0 = this.y;
        this.z0 = this.z;
        this.h0 = this.h;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public double getH() {
        return this.h;
    }

    public double[] getCoords() {
        double[] coords = new double[]{this.x, this.y, this.z, this.h};
        return coords;
    }

    public boolean addToPart(double addition, String part) {
        this.xr = this.x;
        this.yr = this.y;
        this.zr = this.z;
        this.hr = this.h;
        if (part == "x") {
            this.x += addition;
            return true;
        }
        if (part == "y") {
            this.y += addition;
            return true;
        }
        if (part == "z") {
            this.z += addition;
            return true;
        }
        if (part == "h") {
            this.h += addition;
            return true;
        }
        return false;
    }

    public boolean multiplyToPart(double multiple, String part) {
        this.xr = this.x;
        this.yr = this.y;
        this.zr = this.z;
        this.hr = this.h;
        if (part == "x") {
            this.x *= multiple;
            return true;
        }
        if (part == "y") {
            this.y *= multiple;
            return true;
        }
        if (part == "z") {
            this.z *= multiple;
            return true;
        }
        if (part == "h") {
            this.h *= multiple;
            return true;
        }
        return false;
    }

    public boolean rotateLocallyPart(double angle, String part) {
        this.xr = this.x;
        this.yr = this.y;
        this.zr = this.z;
        this.hr = this.h;
        if (part == "x") {
            this.x = this.x;
            this.y = (double)((int)this.y) * Math.cos(angle * (Math.PI / 180)) - (double)((int)this.z) * Math.sin(angle * (Math.PI / 180));
            this.z = (double)((int)this.y) * Math.sin(angle * (Math.PI / 180)) + (double)((int)this.z) * Math.cos(angle * (Math.PI / 180));
        } else {
            if (part == "y") {
                this.x = (double)((int)this.x) * Math.cos(angle * (Math.PI / 180)) + (double)((int)this.z) * Math.sin(angle * (Math.PI / 180));
                this.y = this.y;
                this.z = (double)((int)this.z) * Math.cos(angle * (Math.PI / 180)) - (double)((int)this.x) * Math.sin(angle * (Math.PI / 180));
                return true;
            }
            if (part == "z") {
                this.x = (double)((int)this.x) * Math.cos(angle * (Math.PI / 180)) - this.y * Math.sin(angle * (Math.PI / 180));
                this.y = (double)((int)this.y) * Math.sin(angle * (Math.PI / 180)) + this.y * Math.cos(angle * (Math.PI / 180));
                this.z = this.z;
                System.out.println("Previous point: x; " + this.xr + " y; " + this.yr + " z; " + this.zr);
                System.out.println("Current point: x; " + this.x + " y; " + this.y + " z; " + this.z);
                return true;
            }
        }
        return false;
    }

    public boolean rotateLocally(double xAngle, double yAngle, double zAngle) {
        this.xr = this.x;
        this.yr = this.y;
        this.zr = this.z;
        this.hr = this.h;
        double xt = this.x;
        double yt = this.y;
        double zt = this.z;
        double ht = this.h;
        this.rotateLocallyPart(xAngle, "x");
        this.rotateLocallyPart(yAngle, "y");
        this.rotateLocallyPart(zAngle, "z");
        this.xr = xt;
        this.yr = yt;
        this.zr = zt;
        this.hr = ht;
        return true;
    }

    public boolean changePart(double changeTo, String part) {
        this.xr = this.x;
        this.yr = this.y;
        this.zr = this.z;
        this.hr = this.h;
        if (part == "x") {
            this.x = changeTo;
            return true;
        }
        if (part == "y") {
            this.y = changeTo;
            return true;
        }
        if (part == "z") {
            this.z = changeTo;
            return true;
        }
        if (part == "h") {
            this.h = changeTo;
            return true;
        }
        return false;
    }

    public boolean changeAll(Coords next) {
        try {
            this.xr = this.x;
            this.yr = this.y;
            this.zr = this.z;
            this.hr = this.h;
            this.x = next.getX();
            this.y = next.getY();
            this.z = next.getZ();
            this.h = next.getH();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean rollback() {
        try {
            this.x = this.xr;
            this.y = this.yr;
            this.z = this.zr;
            this.h = this.hr;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean reset() {
        try {
            this.x = this.x0;
            this.y = this.y0;
            this.z = this.z0;
            this.h = this.h0;
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Coords flatten() {
        return this;
    }

    public Coords flattenGlobal() {
        return this;
    }
}

