/*
 * Decompiled with CFR 0.152.
 */
package bounds;

import coords.Coords;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import scenery.Scenery;
import unit.ID;
import unit.Unit;

public class Bounds {
    public Rectangle rect;
    private Coords[] oBound;
    private Coords[] cBound;
    public ID obj;

    public Bounds(Unit un) {
        double x = un.placement.getX();
        double y = un.placement.getY();
        double width = un.width;
        double height = un.height;
        this.rect = new Rectangle((int)x, (int)y, (int)width, (int)height);
        this.obj = un;
    }

    public Bounds(Unit un, Image[] apa) {
        double x = un.placement.getX();
        double y = un.placement.getY();
        double width = un.width;
        double height = un.height;
        Graphics g = apa[0].getGraphics();
        g.clipRect((int)x, (int)y, (int)width, (int)height);
        this.rect = g.getClipBounds();
        this.obj = un;
    }

    public Bounds(Scenery sc) {
        double x = sc.placement.getX();
        double y = sc.placement.getY();
        double width = sc.width;
        double height = sc.height;
        this.rect = new Rectangle((int)x, (int)y, (int)width, (int)height);
        this.obj = sc;
    }

    public Bounds(Coords coords, int i, int j) {
        this.rect = new Rectangle((int)coords.getX(), (int)coords.getY(), i, j);
        this.obj = new ID("Completion", "Completion", "Completion");
    }

    public double getLeftBound() {
        return this.rect.getX();
    }

    public double getRightBound() {
        return this.rect.getX() + (double)this.rect.width;
    }

    public double getUpBound() {
        return this.rect.getY();
    }

    public double getLowBound() {
        return this.rect.getY() + (double)this.rect.height;
    }

    public double getHalfXBound() {
        return this.getRightBound() - (double)(this.rect.width / 2);
    }

    public double getHalfYBound() {
        return this.getLowBound() - (double)(this.rect.height / 2);
    }

    public boolean setOUBounds(int mL, Coords[] path, int index) {
        Coords topLeft = new Coords(this.getLeftBound(), this.getUpBound());
        Coords topRight = new Coords(this.getRightBound(), this.getUpBound());
        Coords bottomLeft = new Coords(this.getLeftBound(), this.getLowBound());
        Coords bottomRight = new Coords(this.getRightBound(), this.getLowBound());
        Coords topHalf = new Coords(this.getHalfXBound(), this.getUpBound() - (double)mL);
        Coords bottomHalf = new Coords(this.getHalfXBound(), this.getUpBound() + (double)mL);
        Coords leftHalf = new Coords(this.getLeftBound() - (double)mL, this.getHalfYBound());
        Coords rightHalf = new Coords(this.getRightBound() + (double)mL, this.getHalfYBound());
        if (this.obj.iD != "Ellipse" && this.obj.iD == "Square") {
            topLeft.addToPart(-mL, "x");
            topLeft.addToPart(-mL, "y");
            topRight.addToPart(mL, "x");
            topRight.addToPart(-mL, "y");
            bottomLeft.addToPart(-mL, "x");
            bottomLeft.addToPart(mL, "y");
            bottomRight.addToPart(mL, "x");
            bottomRight.addToPart(mL, "y");
            topHalf.addToPart(-mL, "y");
            bottomHalf.addToPart(mL, "y");
            leftHalf.addToPart(-mL, "x");
            rightHalf.addToPart(mL, "x");
        }
        if (path[index].getX() <= this.getLeftBound()) {
            Coords[] to = new Coords[]{topLeft, topHalf, topRight};
            this.oBound = to;
            Coords[] ao = new Coords[]{bottomLeft, bottomHalf, bottomRight};
            this.cBound = ao;
            return true;
        }
        if (path[index].getX() >= this.getRightBound()) {
            Coords[] to = new Coords[]{topRight, topHalf, topLeft};
            this.oBound = to;
            Coords[] ao = new Coords[]{bottomRight, bottomHalf, bottomLeft};
            this.cBound = ao;
            return true;
        }
        if (path[index].getY() <= this.getUpBound()) {
            Coords[] to = new Coords[]{topRight, rightHalf, bottomRight};
            this.oBound = to;
            Coords[] ao = new Coords[]{topLeft, leftHalf, bottomLeft};
            this.cBound = ao;
            return true;
        }
        if (path[index].getY() >= this.getLowBound()) {
            Coords[] to = new Coords[]{topLeft, leftHalf, bottomLeft};
            this.oBound = to;
            Coords[] ao = new Coords[]{topRight, rightHalf, bottomRight};
            this.cBound = ao;
            return true;
        }
        return false;
    }

    public Coords[] getOverBounds() {
        return this.oBound;
    }

    public Coords[] getUnderBounds() {
        return this.cBound;
    }
}

